// Code generated by protoc-gen-go. DO NOT EDIT.
// source: storage.proto

package types

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

//后面如果有其他数据模型可继续往上面添加
type Storage struct {
	// Types that are valid to be assigned to Value:
	//	*Storage_ContentStorage
	//	*Storage_HashStorage
	//	*Storage_LinkStorage
	//	*Storage_EncryptStorage
	//	*Storage_EncryptShareStorage
	//	*Storage_EncryptAdd
	Value                isStorage_Value `protobuf_oneof:"value"`
	Ty                   int32           `protobuf:"varint,7,opt,name=ty,proto3" json:"ty,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Storage) Reset()         { *m = Storage{} }
func (m *Storage) String() string { return proto.CompactTextString(m) }
func (*Storage) ProtoMessage()    {}
func (*Storage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{0}
}

func (m *Storage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Storage.Unmarshal(m, b)
}
func (m *Storage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Storage.Marshal(b, m, deterministic)
}
func (m *Storage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Storage.Merge(m, src)
}
func (m *Storage) XXX_Size() int {
	return xxx_messageInfo_Storage.Size(m)
}
func (m *Storage) XXX_DiscardUnknown() {
	xxx_messageInfo_Storage.DiscardUnknown(m)
}

var xxx_messageInfo_Storage proto.InternalMessageInfo

type isStorage_Value interface {
	isStorage_Value()
}

type Storage_ContentStorage struct {
	ContentStorage *ContentOnlyNotaryStorage `protobuf:"bytes,1,opt,name=contentStorage,proto3,oneof"`
}

type Storage_HashStorage struct {
	HashStorage *HashOnlyNotaryStorage `protobuf:"bytes,2,opt,name=hashStorage,proto3,oneof"`
}

type Storage_LinkStorage struct {
	LinkStorage *LinkNotaryStorage `protobuf:"bytes,3,opt,name=linkStorage,proto3,oneof"`
}

type Storage_EncryptStorage struct {
	EncryptStorage *EncryptNotaryStorage `protobuf:"bytes,4,opt,name=encryptStorage,proto3,oneof"`
}

type Storage_EncryptShareStorage struct {
	EncryptShareStorage *EncryptShareNotaryStorage `protobuf:"bytes,5,opt,name=encryptShareStorage,proto3,oneof"`
}

type Storage_EncryptAdd struct {
	EncryptAdd *EncryptNotaryAdd `protobuf:"bytes,6,opt,name=encryptAdd,proto3,oneof"`
}

func (*Storage_ContentStorage) isStorage_Value() {}

func (*Storage_HashStorage) isStorage_Value() {}

func (*Storage_LinkStorage) isStorage_Value() {}

func (*Storage_EncryptStorage) isStorage_Value() {}

func (*Storage_EncryptShareStorage) isStorage_Value() {}

func (*Storage_EncryptAdd) isStorage_Value() {}

func (m *Storage) GetValue() isStorage_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Storage) GetContentStorage() *ContentOnlyNotaryStorage {
	if x, ok := m.GetValue().(*Storage_ContentStorage); ok {
		return x.ContentStorage
	}
	return nil
}

func (m *Storage) GetHashStorage() *HashOnlyNotaryStorage {
	if x, ok := m.GetValue().(*Storage_HashStorage); ok {
		return x.HashStorage
	}
	return nil
}

func (m *Storage) GetLinkStorage() *LinkNotaryStorage {
	if x, ok := m.GetValue().(*Storage_LinkStorage); ok {
		return x.LinkStorage
	}
	return nil
}

func (m *Storage) GetEncryptStorage() *EncryptNotaryStorage {
	if x, ok := m.GetValue().(*Storage_EncryptStorage); ok {
		return x.EncryptStorage
	}
	return nil
}

func (m *Storage) GetEncryptShareStorage() *EncryptShareNotaryStorage {
	if x, ok := m.GetValue().(*Storage_EncryptShareStorage); ok {
		return x.EncryptShareStorage
	}
	return nil
}

func (m *Storage) GetEncryptAdd() *EncryptNotaryAdd {
	if x, ok := m.GetValue().(*Storage_EncryptAdd); ok {
		return x.EncryptAdd
	}
	return nil
}

func (m *Storage) GetTy() int32 {
	if m != nil {
		return m.Ty
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Storage) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Storage_ContentStorage)(nil),
		(*Storage_HashStorage)(nil),
		(*Storage_LinkStorage)(nil),
		(*Storage_EncryptStorage)(nil),
		(*Storage_EncryptShareStorage)(nil),
		(*Storage_EncryptAdd)(nil),
	}
}

type StorageAction struct {
	// Types that are valid to be assigned to Value:
	//	*StorageAction_ContentStorage
	//	*StorageAction_HashStorage
	//	*StorageAction_LinkStorage
	//	*StorageAction_EncryptStorage
	//	*StorageAction_EncryptShareStorage
	//	*StorageAction_EncryptAdd
	Value                isStorageAction_Value `protobuf_oneof:"value"`
	Ty                   int32                 `protobuf:"varint,7,opt,name=ty,proto3" json:"ty,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *StorageAction) Reset()         { *m = StorageAction{} }
func (m *StorageAction) String() string { return proto.CompactTextString(m) }
func (*StorageAction) ProtoMessage()    {}
func (*StorageAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{1}
}

func (m *StorageAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageAction.Unmarshal(m, b)
}
func (m *StorageAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageAction.Marshal(b, m, deterministic)
}
func (m *StorageAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageAction.Merge(m, src)
}
func (m *StorageAction) XXX_Size() int {
	return xxx_messageInfo_StorageAction.Size(m)
}
func (m *StorageAction) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageAction.DiscardUnknown(m)
}

var xxx_messageInfo_StorageAction proto.InternalMessageInfo

type isStorageAction_Value interface {
	isStorageAction_Value()
}

type StorageAction_ContentStorage struct {
	ContentStorage *ContentOnlyNotaryStorage `protobuf:"bytes,1,opt,name=contentStorage,proto3,oneof"`
}

type StorageAction_HashStorage struct {
	HashStorage *HashOnlyNotaryStorage `protobuf:"bytes,2,opt,name=hashStorage,proto3,oneof"`
}

type StorageAction_LinkStorage struct {
	LinkStorage *LinkNotaryStorage `protobuf:"bytes,3,opt,name=linkStorage,proto3,oneof"`
}

type StorageAction_EncryptStorage struct {
	EncryptStorage *EncryptNotaryStorage `protobuf:"bytes,4,opt,name=encryptStorage,proto3,oneof"`
}

type StorageAction_EncryptShareStorage struct {
	EncryptShareStorage *EncryptShareNotaryStorage `protobuf:"bytes,5,opt,name=encryptShareStorage,proto3,oneof"`
}

type StorageAction_EncryptAdd struct {
	EncryptAdd *EncryptNotaryAdd `protobuf:"bytes,6,opt,name=encryptAdd,proto3,oneof"`
}

func (*StorageAction_ContentStorage) isStorageAction_Value() {}

func (*StorageAction_HashStorage) isStorageAction_Value() {}

func (*StorageAction_LinkStorage) isStorageAction_Value() {}

func (*StorageAction_EncryptStorage) isStorageAction_Value() {}

func (*StorageAction_EncryptShareStorage) isStorageAction_Value() {}

func (*StorageAction_EncryptAdd) isStorageAction_Value() {}

func (m *StorageAction) GetValue() isStorageAction_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *StorageAction) GetContentStorage() *ContentOnlyNotaryStorage {
	if x, ok := m.GetValue().(*StorageAction_ContentStorage); ok {
		return x.ContentStorage
	}
	return nil
}

func (m *StorageAction) GetHashStorage() *HashOnlyNotaryStorage {
	if x, ok := m.GetValue().(*StorageAction_HashStorage); ok {
		return x.HashStorage
	}
	return nil
}

func (m *StorageAction) GetLinkStorage() *LinkNotaryStorage {
	if x, ok := m.GetValue().(*StorageAction_LinkStorage); ok {
		return x.LinkStorage
	}
	return nil
}

func (m *StorageAction) GetEncryptStorage() *EncryptNotaryStorage {
	if x, ok := m.GetValue().(*StorageAction_EncryptStorage); ok {
		return x.EncryptStorage
	}
	return nil
}

func (m *StorageAction) GetEncryptShareStorage() *EncryptShareNotaryStorage {
	if x, ok := m.GetValue().(*StorageAction_EncryptShareStorage); ok {
		return x.EncryptShareStorage
	}
	return nil
}

func (m *StorageAction) GetEncryptAdd() *EncryptNotaryAdd {
	if x, ok := m.GetValue().(*StorageAction_EncryptAdd); ok {
		return x.EncryptAdd
	}
	return nil
}

func (m *StorageAction) GetTy() int32 {
	if m != nil {
		return m.Ty
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StorageAction) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StorageAction_ContentStorage)(nil),
		(*StorageAction_HashStorage)(nil),
		(*StorageAction_LinkStorage)(nil),
		(*StorageAction_EncryptStorage)(nil),
		(*StorageAction_EncryptShareStorage)(nil),
		(*StorageAction_EncryptAdd)(nil),
	}
}

// 内容存证模型
type ContentOnlyNotaryStorage struct {
	//长度需要小于512k
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	//自定义的主键，可以为空，如果没传，则用txhash为key
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Op 0表示创建 1表示追加add
	Op int32 `protobuf:"varint,3,opt,name=op,proto3" json:"op,omitempty"`
	//字符串值
	Value                string   `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContentOnlyNotaryStorage) Reset()         { *m = ContentOnlyNotaryStorage{} }
func (m *ContentOnlyNotaryStorage) String() string { return proto.CompactTextString(m) }
func (*ContentOnlyNotaryStorage) ProtoMessage()    {}
func (*ContentOnlyNotaryStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{2}
}

func (m *ContentOnlyNotaryStorage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContentOnlyNotaryStorage.Unmarshal(m, b)
}
func (m *ContentOnlyNotaryStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContentOnlyNotaryStorage.Marshal(b, m, deterministic)
}
func (m *ContentOnlyNotaryStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContentOnlyNotaryStorage.Merge(m, src)
}
func (m *ContentOnlyNotaryStorage) XXX_Size() int {
	return xxx_messageInfo_ContentOnlyNotaryStorage.Size(m)
}
func (m *ContentOnlyNotaryStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_ContentOnlyNotaryStorage.DiscardUnknown(m)
}

var xxx_messageInfo_ContentOnlyNotaryStorage proto.InternalMessageInfo

func (m *ContentOnlyNotaryStorage) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *ContentOnlyNotaryStorage) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *ContentOnlyNotaryStorage) GetOp() int32 {
	if m != nil {
		return m.Op
	}
	return 0
}

func (m *ContentOnlyNotaryStorage) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

//哈希存证模型，推荐使用sha256哈希，限制256位得摘要值
type HashOnlyNotaryStorage struct {
	//长度固定为32字节
	Hash []byte `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	//自定义的主键，可以为空，如果没传，则用txhash为key
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	//字符串值
	Value                string   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HashOnlyNotaryStorage) Reset()         { *m = HashOnlyNotaryStorage{} }
func (m *HashOnlyNotaryStorage) String() string { return proto.CompactTextString(m) }
func (*HashOnlyNotaryStorage) ProtoMessage()    {}
func (*HashOnlyNotaryStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{3}
}

func (m *HashOnlyNotaryStorage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HashOnlyNotaryStorage.Unmarshal(m, b)
}
func (m *HashOnlyNotaryStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HashOnlyNotaryStorage.Marshal(b, m, deterministic)
}
func (m *HashOnlyNotaryStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HashOnlyNotaryStorage.Merge(m, src)
}
func (m *HashOnlyNotaryStorage) XXX_Size() int {
	return xxx_messageInfo_HashOnlyNotaryStorage.Size(m)
}
func (m *HashOnlyNotaryStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_HashOnlyNotaryStorage.DiscardUnknown(m)
}

var xxx_messageInfo_HashOnlyNotaryStorage proto.InternalMessageInfo

func (m *HashOnlyNotaryStorage) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *HashOnlyNotaryStorage) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *HashOnlyNotaryStorage) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// 链接存证模型
type LinkNotaryStorage struct {
	//存证内容的链接，可以写入URL,或者其他可用于定位源文件得线索.
	Link []byte `protobuf:"bytes,1,opt,name=link,proto3" json:"link,omitempty"`
	//源文件得hash值，推荐使用sha256哈希，限制256位得摘要值
	Hash []byte `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	//自定义的主键，可以为空，如果没传，则用txhash为key
	Key string `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	//字符串值
	Value                string   `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinkNotaryStorage) Reset()         { *m = LinkNotaryStorage{} }
func (m *LinkNotaryStorage) String() string { return proto.CompactTextString(m) }
func (*LinkNotaryStorage) ProtoMessage()    {}
func (*LinkNotaryStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{4}
}

func (m *LinkNotaryStorage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LinkNotaryStorage.Unmarshal(m, b)
}
func (m *LinkNotaryStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LinkNotaryStorage.Marshal(b, m, deterministic)
}
func (m *LinkNotaryStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinkNotaryStorage.Merge(m, src)
}
func (m *LinkNotaryStorage) XXX_Size() int {
	return xxx_messageInfo_LinkNotaryStorage.Size(m)
}
func (m *LinkNotaryStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_LinkNotaryStorage.DiscardUnknown(m)
}

var xxx_messageInfo_LinkNotaryStorage proto.InternalMessageInfo

func (m *LinkNotaryStorage) GetLink() []byte {
	if m != nil {
		return m.Link
	}
	return nil
}

func (m *LinkNotaryStorage) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *LinkNotaryStorage) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *LinkNotaryStorage) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// 隐私存证模型，如果一个文件需要存证，且不公开内容，可以选择将源文件通过对称加密算法加密后上链
type EncryptNotaryStorage struct {
	//存证明文内容的hash值，推荐使用sha256哈希，限制256位得摘要值
	ContentHash []byte `protobuf:"bytes,1,opt,name=contentHash,proto3" json:"contentHash,omitempty"`
	//源文件得密文，由加密key及nonce对明文加密得到该值。
	EncryptContent []byte `protobuf:"bytes,2,opt,name=encryptContent,proto3" json:"encryptContent,omitempty"`
	//加密iv，通过AES进行加密时制定随机生成的iv,解密时需要使用该值
	Nonce []byte `protobuf:"bytes,3,opt,name=nonce,proto3" json:"nonce,omitempty"`
	//自定义的主键，可以为空，如果没传，则用txhash为key
	Key string `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	//字符串值
	Value                string   `protobuf:"bytes,5,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptNotaryStorage) Reset()         { *m = EncryptNotaryStorage{} }
func (m *EncryptNotaryStorage) String() string { return proto.CompactTextString(m) }
func (*EncryptNotaryStorage) ProtoMessage()    {}
func (*EncryptNotaryStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{5}
}

func (m *EncryptNotaryStorage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptNotaryStorage.Unmarshal(m, b)
}
func (m *EncryptNotaryStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptNotaryStorage.Marshal(b, m, deterministic)
}
func (m *EncryptNotaryStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptNotaryStorage.Merge(m, src)
}
func (m *EncryptNotaryStorage) XXX_Size() int {
	return xxx_messageInfo_EncryptNotaryStorage.Size(m)
}
func (m *EncryptNotaryStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptNotaryStorage.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptNotaryStorage proto.InternalMessageInfo

func (m *EncryptNotaryStorage) GetContentHash() []byte {
	if m != nil {
		return m.ContentHash
	}
	return nil
}

func (m *EncryptNotaryStorage) GetEncryptContent() []byte {
	if m != nil {
		return m.EncryptContent
	}
	return nil
}

func (m *EncryptNotaryStorage) GetNonce() []byte {
	if m != nil {
		return m.Nonce
	}
	return nil
}

func (m *EncryptNotaryStorage) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *EncryptNotaryStorage) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// 分享隐私存证模型,需要完备的sdk或者相应的密钥库支持
type EncryptShareNotaryStorage struct {
	//存证明文内容的hash值，推荐使用sha256哈希，限制256位得摘要值
	ContentHash []byte `protobuf:"bytes,1,opt,name=contentHash,proto3" json:"contentHash,omitempty"`
	//源文件得密文。,用公钥地址加密
	EncryptContent []byte `protobuf:"bytes,2,opt,name=encryptContent,proto3" json:"encryptContent,omitempty"`
	//公钥
	PubKey []byte `protobuf:"bytes,3,opt,name=pubKey,proto3" json:"pubKey,omitempty"`
	//自定义的主键，可以为空，如果没传，则用txhash为key
	Key string `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	//字符串值
	Value                string   `protobuf:"bytes,5,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptShareNotaryStorage) Reset()         { *m = EncryptShareNotaryStorage{} }
func (m *EncryptShareNotaryStorage) String() string { return proto.CompactTextString(m) }
func (*EncryptShareNotaryStorage) ProtoMessage()    {}
func (*EncryptShareNotaryStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{6}
}

func (m *EncryptShareNotaryStorage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptShareNotaryStorage.Unmarshal(m, b)
}
func (m *EncryptShareNotaryStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptShareNotaryStorage.Marshal(b, m, deterministic)
}
func (m *EncryptShareNotaryStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptShareNotaryStorage.Merge(m, src)
}
func (m *EncryptShareNotaryStorage) XXX_Size() int {
	return xxx_messageInfo_EncryptShareNotaryStorage.Size(m)
}
func (m *EncryptShareNotaryStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptShareNotaryStorage.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptShareNotaryStorage proto.InternalMessageInfo

func (m *EncryptShareNotaryStorage) GetContentHash() []byte {
	if m != nil {
		return m.ContentHash
	}
	return nil
}

func (m *EncryptShareNotaryStorage) GetEncryptContent() []byte {
	if m != nil {
		return m.EncryptContent
	}
	return nil
}

func (m *EncryptShareNotaryStorage) GetPubKey() []byte {
	if m != nil {
		return m.PubKey
	}
	return nil
}

func (m *EncryptShareNotaryStorage) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *EncryptShareNotaryStorage) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// 加密存证数据运算
type EncryptNotaryAdd struct {
	//源操作数存证索引
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	//待操作数据
	EncryptAdd           []byte   `protobuf:"bytes,2,opt,name=encryptAdd,proto3" json:"encryptAdd,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptNotaryAdd) Reset()         { *m = EncryptNotaryAdd{} }
func (m *EncryptNotaryAdd) String() string { return proto.CompactTextString(m) }
func (*EncryptNotaryAdd) ProtoMessage()    {}
func (*EncryptNotaryAdd) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{7}
}

func (m *EncryptNotaryAdd) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptNotaryAdd.Unmarshal(m, b)
}
func (m *EncryptNotaryAdd) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptNotaryAdd.Marshal(b, m, deterministic)
}
func (m *EncryptNotaryAdd) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptNotaryAdd.Merge(m, src)
}
func (m *EncryptNotaryAdd) XXX_Size() int {
	return xxx_messageInfo_EncryptNotaryAdd.Size(m)
}
func (m *EncryptNotaryAdd) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptNotaryAdd.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptNotaryAdd proto.InternalMessageInfo

func (m *EncryptNotaryAdd) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *EncryptNotaryAdd) GetEncryptAdd() []byte {
	if m != nil {
		return m.EncryptAdd
	}
	return nil
}

//根据txhash去状态数据库中查询存储内容
type QueryStorage struct {
	TxHash               string   `protobuf:"bytes,1,opt,name=txHash,proto3" json:"txHash,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryStorage) Reset()         { *m = QueryStorage{} }
func (m *QueryStorage) String() string { return proto.CompactTextString(m) }
func (*QueryStorage) ProtoMessage()    {}
func (*QueryStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{8}
}

func (m *QueryStorage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryStorage.Unmarshal(m, b)
}
func (m *QueryStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryStorage.Marshal(b, m, deterministic)
}
func (m *QueryStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryStorage.Merge(m, src)
}
func (m *QueryStorage) XXX_Size() int {
	return xxx_messageInfo_QueryStorage.Size(m)
}
func (m *QueryStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryStorage.DiscardUnknown(m)
}

var xxx_messageInfo_QueryStorage proto.InternalMessageInfo

func (m *QueryStorage) GetTxHash() string {
	if m != nil {
		return m.TxHash
	}
	return ""
}

//批量查询有可能导致数据库崩溃
type BatchQueryStorage struct {
	TxHashs              []string `protobuf:"bytes,1,rep,name=txHashs,proto3" json:"txHashs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchQueryStorage) Reset()         { *m = BatchQueryStorage{} }
func (m *BatchQueryStorage) String() string { return proto.CompactTextString(m) }
func (*BatchQueryStorage) ProtoMessage()    {}
func (*BatchQueryStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{9}
}

func (m *BatchQueryStorage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchQueryStorage.Unmarshal(m, b)
}
func (m *BatchQueryStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchQueryStorage.Marshal(b, m, deterministic)
}
func (m *BatchQueryStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchQueryStorage.Merge(m, src)
}
func (m *BatchQueryStorage) XXX_Size() int {
	return xxx_messageInfo_BatchQueryStorage.Size(m)
}
func (m *BatchQueryStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchQueryStorage.DiscardUnknown(m)
}

var xxx_messageInfo_BatchQueryStorage proto.InternalMessageInfo

func (m *BatchQueryStorage) GetTxHashs() []string {
	if m != nil {
		return m.TxHashs
	}
	return nil
}

type BatchReplyStorage struct {
	Storages             []*Storage `protobuf:"bytes,1,rep,name=storages,proto3" json:"storages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BatchReplyStorage) Reset()         { *m = BatchReplyStorage{} }
func (m *BatchReplyStorage) String() string { return proto.CompactTextString(m) }
func (*BatchReplyStorage) ProtoMessage()    {}
func (*BatchReplyStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{10}
}

func (m *BatchReplyStorage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchReplyStorage.Unmarshal(m, b)
}
func (m *BatchReplyStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchReplyStorage.Marshal(b, m, deterministic)
}
func (m *BatchReplyStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchReplyStorage.Merge(m, src)
}
func (m *BatchReplyStorage) XXX_Size() int {
	return xxx_messageInfo_BatchReplyStorage.Size(m)
}
func (m *BatchReplyStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchReplyStorage.DiscardUnknown(m)
}

var xxx_messageInfo_BatchReplyStorage proto.InternalMessageInfo

func (m *BatchReplyStorage) GetStorages() []*Storage {
	if m != nil {
		return m.Storages
	}
	return nil
}

type ReceiptStorage struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiptStorage) Reset()         { *m = ReceiptStorage{} }
func (m *ReceiptStorage) String() string { return proto.CompactTextString(m) }
func (*ReceiptStorage) ProtoMessage()    {}
func (*ReceiptStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2c4ccf1453ffdb, []int{11}
}

func (m *ReceiptStorage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptStorage.Unmarshal(m, b)
}
func (m *ReceiptStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptStorage.Marshal(b, m, deterministic)
}
func (m *ReceiptStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptStorage.Merge(m, src)
}
func (m *ReceiptStorage) XXX_Size() int {
	return xxx_messageInfo_ReceiptStorage.Size(m)
}
func (m *ReceiptStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptStorage.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptStorage proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Storage)(nil), "types.Storage")
	proto.RegisterType((*StorageAction)(nil), "types.StorageAction")
	proto.RegisterType((*ContentOnlyNotaryStorage)(nil), "types.ContentOnlyNotaryStorage")
	proto.RegisterType((*HashOnlyNotaryStorage)(nil), "types.HashOnlyNotaryStorage")
	proto.RegisterType((*LinkNotaryStorage)(nil), "types.LinkNotaryStorage")
	proto.RegisterType((*EncryptNotaryStorage)(nil), "types.EncryptNotaryStorage")
	proto.RegisterType((*EncryptShareNotaryStorage)(nil), "types.EncryptShareNotaryStorage")
	proto.RegisterType((*EncryptNotaryAdd)(nil), "types.EncryptNotaryAdd")
	proto.RegisterType((*QueryStorage)(nil), "types.QueryStorage")
	proto.RegisterType((*BatchQueryStorage)(nil), "types.BatchQueryStorage")
	proto.RegisterType((*BatchReplyStorage)(nil), "types.BatchReplyStorage")
	proto.RegisterType((*ReceiptStorage)(nil), "types.ReceiptStorage")
}

func init() {
	proto.RegisterFile("storage.proto", fileDescriptor_0d2c4ccf1453ffdb)
}

var fileDescriptor_0d2c4ccf1453ffdb = []byte{
	// 528 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x95, 0x4d, 0x8b, 0xd3, 0x40,
	0x18, 0xc7, 0x37, 0x4d, 0xd3, 0x98, 0x27, 0xdd, 0xd0, 0x1d, 0xd7, 0x35, 0xa2, 0x68, 0xc8, 0x61,
	0x29, 0x82, 0x3d, 0xd4, 0x93, 0x20, 0x68, 0x57, 0x17, 0x2a, 0x8a, 0xe2, 0xac, 0x5f, 0x20, 0x9b,
	0x0e, 0xa6, 0x34, 0xcc, 0x84, 0x64, 0x2a, 0xe6, 0xcb, 0x78, 0xf3, 0xa3, 0x78, 0xf2, 0x4b, 0x49,
	0x26, 0xcf, 0xa4, 0x49, 0x9b, 0x05, 0x0f, 0x5e, 0x84, 0xbd, 0xcd, 0x3c, 0x2f, 0xbf, 0xe7, 0xe5,
	0x3f, 0x6d, 0xe0, 0xb8, 0x90, 0x22, 0x8f, 0xbe, 0xb2, 0x59, 0x96, 0x0b, 0x29, 0x88, 0x25, 0xcb,
	0x8c, 0x15, 0xe1, 0x2f, 0x13, 0xec, 0xab, 0xda, 0x41, 0xde, 0x81, 0x17, 0x0b, 0x2e, 0x19, 0x97,
	0x68, 0xf1, 0x8d, 0xc0, 0x98, 0xba, 0xf3, 0x27, 0x33, 0x15, 0x3b, 0x7b, 0x53, 0x3b, 0x3f, 0xf1,
	0xb4, 0xfc, 0x28, 0x64, 0x94, 0x97, 0x18, 0xb6, 0x3c, 0xa2, 0x7b, 0x89, 0xe4, 0x35, 0xb8, 0x49,
	0x54, 0x24, 0x9a, 0x33, 0x50, 0x9c, 0x47, 0xc8, 0x59, 0x46, 0x45, 0xd2, 0x07, 0x69, 0xa7, 0x90,
	0x97, 0xe0, 0xa6, 0x6b, 0xbe, 0xd1, 0x04, 0x53, 0x11, 0x7c, 0x24, 0x7c, 0x58, 0xf3, 0xcd, 0x41,
	0x76, 0x2b, 0x9c, 0x5c, 0x82, 0xc7, 0x78, 0x9c, 0x97, 0x59, 0x33, 0xca, 0x50, 0x01, 0x1e, 0x22,
	0xe0, 0xb2, 0x76, 0x1e, 0x8c, 0xd1, 0x4d, 0x22, 0x5f, 0xe0, 0xae, 0xb6, 0x24, 0x51, 0xce, 0x34,
	0xcb, 0x52, 0xac, 0xa0, 0xcb, 0x52, 0x11, 0xfb, 0xc0, 0xbe, 0x74, 0xf2, 0x02, 0x00, 0xcd, 0x8b,
	0xd5, 0xca, 0x1f, 0x29, 0xd8, 0xfd, 0xbe, 0xc6, 0x16, 0xab, 0xd5, 0xf2, 0x88, 0xb6, 0x82, 0x89,
	0x07, 0x03, 0x59, 0xfa, 0x76, 0x60, 0x4c, 0x2d, 0x3a, 0x90, 0xe5, 0x85, 0x0d, 0xd6, 0xb7, 0x28,
	0xdd, 0xb2, 0xf0, 0xb7, 0x09, 0xc7, 0xc8, 0x5f, 0xc4, 0x72, 0x2d, 0xf8, 0xad, 0x9a, 0xff, 0xb1,
	0x9a, 0x29, 0xf8, 0x37, 0xc9, 0x43, 0x7c, 0xb0, 0x51, 0x1e, 0x25, 0xe8, 0x98, 0xea, 0x2b, 0x99,
	0x80, 0xb9, 0x61, 0xa5, 0x92, 0xc7, 0xa1, 0xd5, 0xb1, 0x2a, 0x20, 0x32, 0xb5, 0x6d, 0x8b, 0x0e,
	0x44, 0x46, 0x4e, 0xb1, 0x80, 0xda, 0x9f, 0x43, 0xb1, 0xda, 0x15, 0xdc, 0xeb, 0x15, 0x91, 0x10,
	0x18, 0x56, 0x22, 0x62, 0x1d, 0x75, 0xee, 0x29, 0xd2, 0x40, 0xcd, 0x36, 0x34, 0x86, 0x93, 0x03,
	0x5d, 0x2b, 0x60, 0xa5, 0xab, 0x06, 0x56, 0xe7, 0xa6, 0xc8, 0xe0, 0xb0, 0x88, 0xd9, 0x53, 0xa4,
	0xd3, 0xf9, 0x0f, 0x03, 0x4e, 0xfb, 0xc4, 0x27, 0x01, 0xb8, 0xb8, 0x95, 0xe5, 0x6e, 0x80, 0xb6,
	0x89, 0x9c, 0x37, 0x6f, 0x0a, 0x37, 0x8d, 0x0d, 0xec, 0x59, 0xab, 0xc2, 0x5c, 0xf0, 0xb8, 0x9e,
	0x6e, 0x4c, 0xeb, 0x8b, 0x6e, 0x70, 0xd8, 0xd3, 0xa0, 0xd5, 0x6e, 0xf0, 0xa7, 0x01, 0x0f, 0x6e,
	0x7c, 0x51, 0xff, 0xb0, 0xcb, 0x33, 0x18, 0x65, 0xdb, 0xeb, 0xf7, 0xb8, 0xb3, 0x31, 0xc5, 0xdb,
	0x5f, 0xf7, 0xf9, 0x16, 0x26, 0xfb, 0x6f, 0x55, 0xe7, 0x1a, 0xbb, 0xdc, 0xc7, 0x9d, 0xa7, 0x5e,
	0x77, 0xd2, 0xb2, 0x84, 0xe7, 0x30, 0xfe, 0xbc, 0x65, 0xbb, 0xf9, 0xce, 0x60, 0x24, 0xbf, 0x37,
	0xa3, 0x39, 0x14, 0x6f, 0xe1, 0x33, 0x38, 0xb9, 0x88, 0x64, 0x9c, 0x74, 0x82, 0x7d, 0xb0, 0x6b,
	0x77, 0xe1, 0x1b, 0x81, 0x39, 0x75, 0xa8, 0xbe, 0x86, 0xaf, 0x30, 0x9c, 0xb2, 0x2c, 0x6d, 0xc2,
	0x9f, 0xc2, 0x1d, 0xfc, 0xa0, 0xd5, 0xf1, 0xee, 0xdc, 0xc3, 0x1f, 0x1d, 0x46, 0xd0, 0xc6, 0x1f,
	0x4e, 0xc0, 0xa3, 0x2c, 0x66, 0xeb, 0xe6, 0xaf, 0x60, 0xee, 0x80, 0x8d, 0xde, 0xeb, 0x91, 0xfa,
	0x1e, 0x3e, 0xff, 0x13, 0x00, 0x00, 0xff, 0xff, 0x66, 0xc3, 0x4e, 0x48, 0x20, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StorageClient is the client API for Storage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StorageClient interface {
}

type storageClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageClient(cc grpc.ClientConnInterface) StorageClient {
	return &storageClient{cc}
}

// StorageServer is the server API for Storage service.
type StorageServer interface {
}

// UnimplementedStorageServer can be embedded to have forward compatible implementations.
type UnimplementedStorageServer struct {
}

func RegisterStorageServer(s *grpc.Server, srv StorageServer) {
	s.RegisterService(&_Storage_serviceDesc, srv)
}

var _Storage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "types.storage",
	HandlerType: (*StorageServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams:     []grpc.StreamDesc{},
	Metadata:    "storage.proto",
}
