# paracross 执行器 授权账户管理

## 场景
 1. 平行链申请开链之前申请几个授权账户作为超级节点，没有授权账户无法做跨链交易
 1. 申请超级节点需要在主链冻结一定资金，超级节点用户需要在主链先把一定的币转到paracross合约，再在平行链申请
 1. 超级节点账户组申请支持一次提交多个账户，其中一个账户申请，提交的这些账户必须都在主链转需要的币到paracross合约
 1. 主链超级账户审批申请的超级节点账户组，审批通过后，超级节点账户组不能撤销，审批通过前允许撤销
 1. 每个平行链只允许建一个超级节点账户组，后面想加入的账户，只能使用单个节点加入功能
 1. 超级节点账户组审核后续新授权账户的添加和退出申请工作，必须除自己外，超过2/3数同意才可加入和退出，
    如果只剩最后一个账户，则不允许退出，如果随意退出有只留下僵尸授权账户风险，平行链失控
 1. 当前授权账户有投票删除某一个授权账户的权利，2/3数投同样票的规则
 1. 在所有超级节点都失效或什么原因导致没有超级节点发送共识或不满足2/3节点，导致共识高度不增长，若超过一定高度，超级账户投票有直接通过权利，
    尤其是在当前授权账户不足2/3达不成共识时候，需要超级账户干预
 1. 特殊或异常场景：
    1. 申请节点退出后重新申请,允许重新加入，但需要重新投票
    1. 新申请节点投票超过2/3否决，后来又投票超过2/3同意，可以加入或退出   
    
## 四个状态
```
    +----------------------------------+
    |                                  |
  adding  --+ added --+ quiting --+ quited
                |                      |
                -----------------------+
``` 
  1. adding:  新授权账户申请状态，若投票超过2/3否决停留在此状态，后续可以继续投赞成票
  1. added:   授权账户被当前授权账户组超过2/3票通过状态
  1. quiting: 当前授权账户申请退出账户组状态，投票超过2/3否决停留在此状态，后续可以继续投赞成票
  1. quited:  授权账户quiting被账户组除自己外账户投票超过2/3通过状态，或added的账户被账户组除自己外投票超过2/3否决除名状态   
  
## 测试场景：
### 超级节点账户组
 1. 待申请超级账户发起申请，申请多个账户组，用“，”隔开，锁币参数超过或等于配置参数，查看状态为1，申请状态，币锁定
 1. 配置参数为0，待申请账户发起申请参数也为0，可以通过申请
 1. 待申请账户任一账户发起撤销交易，申请取消，币解锁
 1. 待申请超级账户发起申请后，超级账户approve申请，若任一非超级账户approve会失败
 1. approve之后，任一申请账户发起撤销交易失败
 
### 超级节点配置： 
 1. 新节点发tx申请加入，超2/3同意，新节点加入成功处于added状态
 1. 已加入节点申请退出，超2/3同意，已加入节点退出管理组处于quited状态
 1. 新节点重新申请加入，超2/3否决，新节点仍停留在adding状态，后来投票节点又2/3同意，新节点加入
 1. 投票节点一起投某一个账户组里面的账户否决票，超2/3数后，此账户退出账户组，又超过2/3同意后，仍处于退出状态（需自己申请加入）
 1. 账户组里面账户申请退出，当是最后一个时候退出失败
 1. 配4个节点，只有2个可以投票发共识消息，共识停止，2个新节点申请加入，超过配置高度后，超级账户vote后通过，加入管理组参与共识             