// Code generated by protoc-gen-go. DO NOT EDIT.
// source: multisig.proto

package types

import (
	fmt "fmt"
	math "math"

	types "github.com/33cn/chain33/types"
	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

//////////////////////////////////////////////////////////////////////////////
// message for multisig start/////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//多重签名账户的状态信息，存在在statedb中，通过多重签名账户作为key值
// createaddr: 创建多重签名地址的创建者账户
// multisigaddr: 多重签名地址
// owners: 可以操作此多重签名地址的owner账户列表
// DailyLimit: 不同资产的每日限额，通过symbol来区分，本连的原生币，以及跨链过来的其他链的原生币
// txCount:记录此多重签名地址上提交的withdraw交易数
// requiredweight:确认一笔withdraw交易需要的权重。
type MultiSig struct {
	CreateAddr           string        `protobuf:"bytes,1,opt,name=createAddr,proto3" json:"createAddr,omitempty"`
	MultiSigAddr         string        `protobuf:"bytes,2,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	Owners               []*Owner      `protobuf:"bytes,3,rep,name=owners,proto3" json:"owners,omitempty"`
	DailyLimits          []*DailyLimit `protobuf:"bytes,4,rep,name=dailyLimits,proto3" json:"dailyLimits,omitempty"`
	TxCount              uint64        `protobuf:"varint,5,opt,name=txCount,proto3" json:"txCount,omitempty"`
	RequiredWeight       uint64        `protobuf:"varint,6,opt,name=requiredWeight,proto3" json:"requiredWeight,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *MultiSig) Reset()         { *m = MultiSig{} }
func (m *MultiSig) String() string { return proto.CompactTextString(m) }
func (*MultiSig) ProtoMessage()    {}
func (*MultiSig) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{0}
}

func (m *MultiSig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSig.Unmarshal(m, b)
}
func (m *MultiSig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSig.Marshal(b, m, deterministic)
}
func (m *MultiSig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSig.Merge(m, src)
}
func (m *MultiSig) XXX_Size() int {
	return xxx_messageInfo_MultiSig.Size(m)
}
func (m *MultiSig) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSig.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSig proto.InternalMessageInfo

func (m *MultiSig) GetCreateAddr() string {
	if m != nil {
		return m.CreateAddr
	}
	return ""
}

func (m *MultiSig) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *MultiSig) GetOwners() []*Owner {
	if m != nil {
		return m.Owners
	}
	return nil
}

func (m *MultiSig) GetDailyLimits() []*DailyLimit {
	if m != nil {
		return m.DailyLimits
	}
	return nil
}

func (m *MultiSig) GetTxCount() uint64 {
	if m != nil {
		return m.TxCount
	}
	return 0
}

func (m *MultiSig) GetRequiredWeight() uint64 {
	if m != nil {
		return m.RequiredWeight
	}
	return 0
}

//这个地址是否已经确认某个交易
type ConfirmedOwner struct {
	ConfirmedOwner       []*Owner `protobuf:"bytes,1,rep,name=confirmedOwner,proto3" json:"confirmedOwner,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfirmedOwner) Reset()         { *m = ConfirmedOwner{} }
func (m *ConfirmedOwner) String() string { return proto.CompactTextString(m) }
func (*ConfirmedOwner) ProtoMessage()    {}
func (*ConfirmedOwner) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{1}
}

func (m *ConfirmedOwner) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfirmedOwner.Unmarshal(m, b)
}
func (m *ConfirmedOwner) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfirmedOwner.Marshal(b, m, deterministic)
}
func (m *ConfirmedOwner) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfirmedOwner.Merge(m, src)
}
func (m *ConfirmedOwner) XXX_Size() int {
	return xxx_messageInfo_ConfirmedOwner.Size(m)
}
func (m *ConfirmedOwner) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfirmedOwner.DiscardUnknown(m)
}

var xxx_messageInfo_ConfirmedOwner proto.InternalMessageInfo

func (m *ConfirmedOwner) GetConfirmedOwner() []*Owner {
	if m != nil {
		return m.ConfirmedOwner
	}
	return nil
}

//记录提交的交易详情，在满足确认条件后执行data中的交易
// txHash:用于存贮提交的确认交易。存贮在localdb中，通过txhash可以获取
type MultiSigTx struct {
	Txid                 uint64   `protobuf:"varint,1,opt,name=txid,proto3" json:"txid,omitempty"`
	TxHash               string   `protobuf:"bytes,2,opt,name=txHash,proto3" json:"txHash,omitempty"`
	Executed             bool     `protobuf:"varint,3,opt,name=executed,proto3" json:"executed,omitempty"`
	TxType               uint64   `protobuf:"varint,4,opt,name=txType,proto3" json:"txType,omitempty"`
	MultiSigAddr         string   `protobuf:"bytes,5,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	ConfirmedOwner       []*Owner `protobuf:"bytes,6,rep,name=confirmedOwner,proto3" json:"confirmedOwner,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiSigTx) Reset()         { *m = MultiSigTx{} }
func (m *MultiSigTx) String() string { return proto.CompactTextString(m) }
func (*MultiSigTx) ProtoMessage()    {}
func (*MultiSigTx) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{2}
}

func (m *MultiSigTx) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSigTx.Unmarshal(m, b)
}
func (m *MultiSigTx) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSigTx.Marshal(b, m, deterministic)
}
func (m *MultiSigTx) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSigTx.Merge(m, src)
}
func (m *MultiSigTx) XXX_Size() int {
	return xxx_messageInfo_MultiSigTx.Size(m)
}
func (m *MultiSigTx) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSigTx.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSigTx proto.InternalMessageInfo

func (m *MultiSigTx) GetTxid() uint64 {
	if m != nil {
		return m.Txid
	}
	return 0
}

func (m *MultiSigTx) GetTxHash() string {
	if m != nil {
		return m.TxHash
	}
	return ""
}

func (m *MultiSigTx) GetExecuted() bool {
	if m != nil {
		return m.Executed
	}
	return false
}

func (m *MultiSigTx) GetTxType() uint64 {
	if m != nil {
		return m.TxType
	}
	return 0
}

func (m *MultiSigTx) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *MultiSigTx) GetConfirmedOwner() []*Owner {
	if m != nil {
		return m.ConfirmedOwner
	}
	return nil
}

// owner 结构体：owner账户地址，以及权重
type Owner struct {
	OwnerAddr            string   `protobuf:"bytes,1,opt,name=ownerAddr,proto3" json:"ownerAddr,omitempty"`
	Weight               uint64   `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Owner) Reset()         { *m = Owner{} }
func (m *Owner) String() string { return proto.CompactTextString(m) }
func (*Owner) ProtoMessage()    {}
func (*Owner) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{3}
}

func (m *Owner) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Owner.Unmarshal(m, b)
}
func (m *Owner) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Owner.Marshal(b, m, deterministic)
}
func (m *Owner) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Owner.Merge(m, src)
}
func (m *Owner) XXX_Size() int {
	return xxx_messageInfo_Owner.Size(m)
}
func (m *Owner) XXX_DiscardUnknown() {
	xxx_messageInfo_Owner.DiscardUnknown(m)
}

var xxx_messageInfo_Owner proto.InternalMessageInfo

func (m *Owner) GetOwnerAddr() string {
	if m != nil {
		return m.OwnerAddr
	}
	return ""
}

func (m *Owner) GetWeight() uint64 {
	if m != nil {
		return m.Weight
	}
	return 0
}

//每日资产限额，不同的资产价格不一致，需要设置各自的每日限额。没有设置或者限额是0时，表示不能取币
// spentToday今天已经花费的额度。用于和dailyLimit做对比，超过每日限额时需要多重签名
// lastDay记录当天开始的时间戳，新的一天需要重置spentToday为初始值0，并修改lastDay的时间戳
type DailyLimit struct {
	Symbol               string   `protobuf:"bytes,1,opt,name=symbol,proto3" json:"symbol,omitempty"`
	Execer               string   `protobuf:"bytes,2,opt,name=execer,proto3" json:"execer,omitempty"`
	DailyLimit           uint64   `protobuf:"varint,3,opt,name=dailyLimit,proto3" json:"dailyLimit,omitempty"`
	SpentToday           uint64   `protobuf:"varint,4,opt,name=spentToday,proto3" json:"spentToday,omitempty"`
	LastDay              int64    `protobuf:"varint,5,opt,name=lastDay,proto3" json:"lastDay,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DailyLimit) Reset()         { *m = DailyLimit{} }
func (m *DailyLimit) String() string { return proto.CompactTextString(m) }
func (*DailyLimit) ProtoMessage()    {}
func (*DailyLimit) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{4}
}

func (m *DailyLimit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DailyLimit.Unmarshal(m, b)
}
func (m *DailyLimit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DailyLimit.Marshal(b, m, deterministic)
}
func (m *DailyLimit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DailyLimit.Merge(m, src)
}
func (m *DailyLimit) XXX_Size() int {
	return xxx_messageInfo_DailyLimit.Size(m)
}
func (m *DailyLimit) XXX_DiscardUnknown() {
	xxx_messageInfo_DailyLimit.DiscardUnknown(m)
}

var xxx_messageInfo_DailyLimit proto.InternalMessageInfo

func (m *DailyLimit) GetSymbol() string {
	if m != nil {
		return m.Symbol
	}
	return ""
}

func (m *DailyLimit) GetExecer() string {
	if m != nil {
		return m.Execer
	}
	return ""
}

func (m *DailyLimit) GetDailyLimit() uint64 {
	if m != nil {
		return m.DailyLimit
	}
	return 0
}

func (m *DailyLimit) GetSpentToday() uint64 {
	if m != nil {
		return m.SpentToday
	}
	return 0
}

func (m *DailyLimit) GetLastDay() int64 {
	if m != nil {
		return m.LastDay
	}
	return 0
}

type SymbolDailyLimit struct {
	Symbol               string   `protobuf:"bytes,1,opt,name=symbol,proto3" json:"symbol,omitempty"`
	Execer               string   `protobuf:"bytes,2,opt,name=execer,proto3" json:"execer,omitempty"`
	DailyLimit           uint64   `protobuf:"varint,3,opt,name=dailyLimit,proto3" json:"dailyLimit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SymbolDailyLimit) Reset()         { *m = SymbolDailyLimit{} }
func (m *SymbolDailyLimit) String() string { return proto.CompactTextString(m) }
func (*SymbolDailyLimit) ProtoMessage()    {}
func (*SymbolDailyLimit) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{5}
}

func (m *SymbolDailyLimit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SymbolDailyLimit.Unmarshal(m, b)
}
func (m *SymbolDailyLimit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SymbolDailyLimit.Marshal(b, m, deterministic)
}
func (m *SymbolDailyLimit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SymbolDailyLimit.Merge(m, src)
}
func (m *SymbolDailyLimit) XXX_Size() int {
	return xxx_messageInfo_SymbolDailyLimit.Size(m)
}
func (m *SymbolDailyLimit) XXX_DiscardUnknown() {
	xxx_messageInfo_SymbolDailyLimit.DiscardUnknown(m)
}

var xxx_messageInfo_SymbolDailyLimit proto.InternalMessageInfo

func (m *SymbolDailyLimit) GetSymbol() string {
	if m != nil {
		return m.Symbol
	}
	return ""
}

func (m *SymbolDailyLimit) GetExecer() string {
	if m != nil {
		return m.Execer
	}
	return ""
}

func (m *SymbolDailyLimit) GetDailyLimit() uint64 {
	if m != nil {
		return m.DailyLimit
	}
	return 0
}

// MultiSig 所有可能的交易action
type MultiSigAction struct {
	// Types that are valid to be assigned to Value:
	//	*MultiSigAction_MultiSigAccCreate
	//	*MultiSigAction_MultiSigOwnerOperate
	//	*MultiSigAction_MultiSigAccOperate
	//	*MultiSigAction_MultiSigConfirmTx
	//	*MultiSigAction_MultiSigExecTransferTo
	//	*MultiSigAction_MultiSigExecTransferFrom
	Value                isMultiSigAction_Value `protobuf_oneof:"value"`
	Ty                   int32                  `protobuf:"varint,7,opt,name=Ty,proto3" json:"Ty,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *MultiSigAction) Reset()         { *m = MultiSigAction{} }
func (m *MultiSigAction) String() string { return proto.CompactTextString(m) }
func (*MultiSigAction) ProtoMessage()    {}
func (*MultiSigAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{6}
}

func (m *MultiSigAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSigAction.Unmarshal(m, b)
}
func (m *MultiSigAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSigAction.Marshal(b, m, deterministic)
}
func (m *MultiSigAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSigAction.Merge(m, src)
}
func (m *MultiSigAction) XXX_Size() int {
	return xxx_messageInfo_MultiSigAction.Size(m)
}
func (m *MultiSigAction) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSigAction.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSigAction proto.InternalMessageInfo

type isMultiSigAction_Value interface {
	isMultiSigAction_Value()
}

type MultiSigAction_MultiSigAccCreate struct {
	MultiSigAccCreate *MultiSigAccCreate `protobuf:"bytes,1,opt,name=multiSigAccCreate,proto3,oneof"`
}

type MultiSigAction_MultiSigOwnerOperate struct {
	MultiSigOwnerOperate *MultiSigOwnerOperate `protobuf:"bytes,2,opt,name=multiSigOwnerOperate,proto3,oneof"`
}

type MultiSigAction_MultiSigAccOperate struct {
	MultiSigAccOperate *MultiSigAccOperate `protobuf:"bytes,3,opt,name=multiSigAccOperate,proto3,oneof"`
}

type MultiSigAction_MultiSigConfirmTx struct {
	MultiSigConfirmTx *MultiSigConfirmTx `protobuf:"bytes,4,opt,name=multiSigConfirmTx,proto3,oneof"`
}

type MultiSigAction_MultiSigExecTransferTo struct {
	MultiSigExecTransferTo *MultiSigExecTransferTo `protobuf:"bytes,5,opt,name=multiSigExecTransferTo,proto3,oneof"`
}

type MultiSigAction_MultiSigExecTransferFrom struct {
	MultiSigExecTransferFrom *MultiSigExecTransferFrom `protobuf:"bytes,6,opt,name=multiSigExecTransferFrom,proto3,oneof"`
}

func (*MultiSigAction_MultiSigAccCreate) isMultiSigAction_Value() {}

func (*MultiSigAction_MultiSigOwnerOperate) isMultiSigAction_Value() {}

func (*MultiSigAction_MultiSigAccOperate) isMultiSigAction_Value() {}

func (*MultiSigAction_MultiSigConfirmTx) isMultiSigAction_Value() {}

func (*MultiSigAction_MultiSigExecTransferTo) isMultiSigAction_Value() {}

func (*MultiSigAction_MultiSigExecTransferFrom) isMultiSigAction_Value() {}

func (m *MultiSigAction) GetValue() isMultiSigAction_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *MultiSigAction) GetMultiSigAccCreate() *MultiSigAccCreate {
	if x, ok := m.GetValue().(*MultiSigAction_MultiSigAccCreate); ok {
		return x.MultiSigAccCreate
	}
	return nil
}

func (m *MultiSigAction) GetMultiSigOwnerOperate() *MultiSigOwnerOperate {
	if x, ok := m.GetValue().(*MultiSigAction_MultiSigOwnerOperate); ok {
		return x.MultiSigOwnerOperate
	}
	return nil
}

func (m *MultiSigAction) GetMultiSigAccOperate() *MultiSigAccOperate {
	if x, ok := m.GetValue().(*MultiSigAction_MultiSigAccOperate); ok {
		return x.MultiSigAccOperate
	}
	return nil
}

func (m *MultiSigAction) GetMultiSigConfirmTx() *MultiSigConfirmTx {
	if x, ok := m.GetValue().(*MultiSigAction_MultiSigConfirmTx); ok {
		return x.MultiSigConfirmTx
	}
	return nil
}

func (m *MultiSigAction) GetMultiSigExecTransferTo() *MultiSigExecTransferTo {
	if x, ok := m.GetValue().(*MultiSigAction_MultiSigExecTransferTo); ok {
		return x.MultiSigExecTransferTo
	}
	return nil
}

func (m *MultiSigAction) GetMultiSigExecTransferFrom() *MultiSigExecTransferFrom {
	if x, ok := m.GetValue().(*MultiSigAction_MultiSigExecTransferFrom); ok {
		return x.MultiSigExecTransferFrom
	}
	return nil
}

func (m *MultiSigAction) GetTy() int32 {
	if m != nil {
		return m.Ty
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MultiSigAction) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MultiSigAction_MultiSigAccCreate)(nil),
		(*MultiSigAction_MultiSigOwnerOperate)(nil),
		(*MultiSigAction_MultiSigAccOperate)(nil),
		(*MultiSigAction_MultiSigConfirmTx)(nil),
		(*MultiSigAction_MultiSigExecTransferTo)(nil),
		(*MultiSigAction_MultiSigExecTransferFrom)(nil),
	}
}

//创建多重签名账户时需要的信息：创建时最少初始化两个owners，资产的每日限额初始时可以不设置
type MultiSigAccCreate struct {
	Owners               []*Owner          `protobuf:"bytes,1,rep,name=owners,proto3" json:"owners,omitempty"`
	RequiredWeight       uint64            `protobuf:"varint,2,opt,name=requiredWeight,proto3" json:"requiredWeight,omitempty"`
	DailyLimit           *SymbolDailyLimit `protobuf:"bytes,3,opt,name=dailyLimit,proto3" json:"dailyLimit,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MultiSigAccCreate) Reset()         { *m = MultiSigAccCreate{} }
func (m *MultiSigAccCreate) String() string { return proto.CompactTextString(m) }
func (*MultiSigAccCreate) ProtoMessage()    {}
func (*MultiSigAccCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{7}
}

func (m *MultiSigAccCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSigAccCreate.Unmarshal(m, b)
}
func (m *MultiSigAccCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSigAccCreate.Marshal(b, m, deterministic)
}
func (m *MultiSigAccCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSigAccCreate.Merge(m, src)
}
func (m *MultiSigAccCreate) XXX_Size() int {
	return xxx_messageInfo_MultiSigAccCreate.Size(m)
}
func (m *MultiSigAccCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSigAccCreate.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSigAccCreate proto.InternalMessageInfo

func (m *MultiSigAccCreate) GetOwners() []*Owner {
	if m != nil {
		return m.Owners
	}
	return nil
}

func (m *MultiSigAccCreate) GetRequiredWeight() uint64 {
	if m != nil {
		return m.RequiredWeight
	}
	return 0
}

func (m *MultiSigAccCreate) GetDailyLimit() *SymbolDailyLimit {
	if m != nil {
		return m.DailyLimit
	}
	return nil
}

//对MultiSigAccount账户owner的操作：add/del/replace/modify
type MultiSigOwnerOperate struct {
	MultiSigAccAddr      string   `protobuf:"bytes,1,opt,name=multiSigAccAddr,proto3" json:"multiSigAccAddr,omitempty"`
	OldOwner             string   `protobuf:"bytes,2,opt,name=oldOwner,proto3" json:"oldOwner,omitempty"`
	NewOwner             string   `protobuf:"bytes,3,opt,name=newOwner,proto3" json:"newOwner,omitempty"`
	NewWeight            uint64   `protobuf:"varint,4,opt,name=newWeight,proto3" json:"newWeight,omitempty"`
	OperateFlag          uint64   `protobuf:"varint,5,opt,name=operateFlag,proto3" json:"operateFlag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiSigOwnerOperate) Reset()         { *m = MultiSigOwnerOperate{} }
func (m *MultiSigOwnerOperate) String() string { return proto.CompactTextString(m) }
func (*MultiSigOwnerOperate) ProtoMessage()    {}
func (*MultiSigOwnerOperate) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{8}
}

func (m *MultiSigOwnerOperate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSigOwnerOperate.Unmarshal(m, b)
}
func (m *MultiSigOwnerOperate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSigOwnerOperate.Marshal(b, m, deterministic)
}
func (m *MultiSigOwnerOperate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSigOwnerOperate.Merge(m, src)
}
func (m *MultiSigOwnerOperate) XXX_Size() int {
	return xxx_messageInfo_MultiSigOwnerOperate.Size(m)
}
func (m *MultiSigOwnerOperate) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSigOwnerOperate.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSigOwnerOperate proto.InternalMessageInfo

func (m *MultiSigOwnerOperate) GetMultiSigAccAddr() string {
	if m != nil {
		return m.MultiSigAccAddr
	}
	return ""
}

func (m *MultiSigOwnerOperate) GetOldOwner() string {
	if m != nil {
		return m.OldOwner
	}
	return ""
}

func (m *MultiSigOwnerOperate) GetNewOwner() string {
	if m != nil {
		return m.NewOwner
	}
	return ""
}

func (m *MultiSigOwnerOperate) GetNewWeight() uint64 {
	if m != nil {
		return m.NewWeight
	}
	return 0
}

func (m *MultiSigOwnerOperate) GetOperateFlag() uint64 {
	if m != nil {
		return m.OperateFlag
	}
	return 0
}

//对MultiSigAccount账户的操作：modify/add:SymbolDailyLimit,requiredweight
//修改或者添加每日限额，或者请求权重的值。
type MultiSigAccOperate struct {
	MultiSigAccAddr      string            `protobuf:"bytes,1,opt,name=multiSigAccAddr,proto3" json:"multiSigAccAddr,omitempty"`
	DailyLimit           *SymbolDailyLimit `protobuf:"bytes,2,opt,name=dailyLimit,proto3" json:"dailyLimit,omitempty"`
	NewRequiredWeight    uint64            `protobuf:"varint,3,opt,name=newRequiredWeight,proto3" json:"newRequiredWeight,omitempty"`
	OperateFlag          bool              `protobuf:"varint,4,opt,name=operateFlag,proto3" json:"operateFlag,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MultiSigAccOperate) Reset()         { *m = MultiSigAccOperate{} }
func (m *MultiSigAccOperate) String() string { return proto.CompactTextString(m) }
func (*MultiSigAccOperate) ProtoMessage()    {}
func (*MultiSigAccOperate) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{9}
}

func (m *MultiSigAccOperate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSigAccOperate.Unmarshal(m, b)
}
func (m *MultiSigAccOperate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSigAccOperate.Marshal(b, m, deterministic)
}
func (m *MultiSigAccOperate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSigAccOperate.Merge(m, src)
}
func (m *MultiSigAccOperate) XXX_Size() int {
	return xxx_messageInfo_MultiSigAccOperate.Size(m)
}
func (m *MultiSigAccOperate) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSigAccOperate.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSigAccOperate proto.InternalMessageInfo

func (m *MultiSigAccOperate) GetMultiSigAccAddr() string {
	if m != nil {
		return m.MultiSigAccAddr
	}
	return ""
}

func (m *MultiSigAccOperate) GetDailyLimit() *SymbolDailyLimit {
	if m != nil {
		return m.DailyLimit
	}
	return nil
}

func (m *MultiSigAccOperate) GetNewRequiredWeight() uint64 {
	if m != nil {
		return m.NewRequiredWeight
	}
	return 0
}

func (m *MultiSigAccOperate) GetOperateFlag() bool {
	if m != nil {
		return m.OperateFlag
	}
	return false
}

//多重签名合约中账户之间转币操作:增加一个from的字段实现MultiSigAddr--->addr之间的转账
//需要判断from地址是否是多重签名地址
//将MultiSig合约中from地址上execname+symbol的资产转移到to地址
type MultiSigExecTransferFrom struct {
	Symbol               string   `protobuf:"bytes,1,opt,name=symbol,proto3" json:"symbol,omitempty"`
	Amount               int64    `protobuf:"varint,2,opt,name=amount,proto3" json:"amount,omitempty"`
	Note                 string   `protobuf:"bytes,3,opt,name=note,proto3" json:"note,omitempty"`
	Execname             string   `protobuf:"bytes,4,opt,name=execname,proto3" json:"execname,omitempty"`
	To                   string   `protobuf:"bytes,5,opt,name=to,proto3" json:"to,omitempty"`
	From                 string   `protobuf:"bytes,6,opt,name=from,proto3" json:"from,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiSigExecTransferFrom) Reset()         { *m = MultiSigExecTransferFrom{} }
func (m *MultiSigExecTransferFrom) String() string { return proto.CompactTextString(m) }
func (*MultiSigExecTransferFrom) ProtoMessage()    {}
func (*MultiSigExecTransferFrom) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{10}
}

func (m *MultiSigExecTransferFrom) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSigExecTransferFrom.Unmarshal(m, b)
}
func (m *MultiSigExecTransferFrom) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSigExecTransferFrom.Marshal(b, m, deterministic)
}
func (m *MultiSigExecTransferFrom) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSigExecTransferFrom.Merge(m, src)
}
func (m *MultiSigExecTransferFrom) XXX_Size() int {
	return xxx_messageInfo_MultiSigExecTransferFrom.Size(m)
}
func (m *MultiSigExecTransferFrom) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSigExecTransferFrom.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSigExecTransferFrom proto.InternalMessageInfo

func (m *MultiSigExecTransferFrom) GetSymbol() string {
	if m != nil {
		return m.Symbol
	}
	return ""
}

func (m *MultiSigExecTransferFrom) GetAmount() int64 {
	if m != nil {
		return m.Amount
	}
	return 0
}

func (m *MultiSigExecTransferFrom) GetNote() string {
	if m != nil {
		return m.Note
	}
	return ""
}

func (m *MultiSigExecTransferFrom) GetExecname() string {
	if m != nil {
		return m.Execname
	}
	return ""
}

func (m *MultiSigExecTransferFrom) GetTo() string {
	if m != nil {
		return m.To
	}
	return ""
}

func (m *MultiSigExecTransferFrom) GetFrom() string {
	if m != nil {
		return m.From
	}
	return ""
}

//多重签名合约中账户之间转币操作: addr --->MultiSigAddr之间的转账
//需要判断to地址是否是多重签名地址
//将MultiSig合约中签名地址上execname+symbol的资产转移到to地址
type MultiSigExecTransferTo struct {
	Symbol               string   `protobuf:"bytes,1,opt,name=symbol,proto3" json:"symbol,omitempty"`
	Amount               int64    `protobuf:"varint,2,opt,name=amount,proto3" json:"amount,omitempty"`
	Note                 string   `protobuf:"bytes,3,opt,name=note,proto3" json:"note,omitempty"`
	Execname             string   `protobuf:"bytes,4,opt,name=execname,proto3" json:"execname,omitempty"`
	To                   string   `protobuf:"bytes,5,opt,name=to,proto3" json:"to,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiSigExecTransferTo) Reset()         { *m = MultiSigExecTransferTo{} }
func (m *MultiSigExecTransferTo) String() string { return proto.CompactTextString(m) }
func (*MultiSigExecTransferTo) ProtoMessage()    {}
func (*MultiSigExecTransferTo) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{11}
}

func (m *MultiSigExecTransferTo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSigExecTransferTo.Unmarshal(m, b)
}
func (m *MultiSigExecTransferTo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSigExecTransferTo.Marshal(b, m, deterministic)
}
func (m *MultiSigExecTransferTo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSigExecTransferTo.Merge(m, src)
}
func (m *MultiSigExecTransferTo) XXX_Size() int {
	return xxx_messageInfo_MultiSigExecTransferTo.Size(m)
}
func (m *MultiSigExecTransferTo) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSigExecTransferTo.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSigExecTransferTo proto.InternalMessageInfo

func (m *MultiSigExecTransferTo) GetSymbol() string {
	if m != nil {
		return m.Symbol
	}
	return ""
}

func (m *MultiSigExecTransferTo) GetAmount() int64 {
	if m != nil {
		return m.Amount
	}
	return 0
}

func (m *MultiSigExecTransferTo) GetNote() string {
	if m != nil {
		return m.Note
	}
	return ""
}

func (m *MultiSigExecTransferTo) GetExecname() string {
	if m != nil {
		return m.Execname
	}
	return ""
}

func (m *MultiSigExecTransferTo) GetTo() string {
	if m != nil {
		return m.To
	}
	return ""
}

//多重签名账户withdraw交易的确认或者取消确认
// multisigaccaddr:多重签名账户地址
// transactionid:多重签名账户上的withdraw交易的内部id
type MultiSigConfirmTx struct {
	MultiSigAccAddr      string   `protobuf:"bytes,1,opt,name=multiSigAccAddr,proto3" json:"multiSigAccAddr,omitempty"`
	TxId                 uint64   `protobuf:"varint,2,opt,name=txId,proto3" json:"txId,omitempty"`
	ConfirmOrRevoke      bool     `protobuf:"varint,3,opt,name=confirmOrRevoke,proto3" json:"confirmOrRevoke,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiSigConfirmTx) Reset()         { *m = MultiSigConfirmTx{} }
func (m *MultiSigConfirmTx) String() string { return proto.CompactTextString(m) }
func (*MultiSigConfirmTx) ProtoMessage()    {}
func (*MultiSigConfirmTx) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{12}
}

func (m *MultiSigConfirmTx) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSigConfirmTx.Unmarshal(m, b)
}
func (m *MultiSigConfirmTx) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSigConfirmTx.Marshal(b, m, deterministic)
}
func (m *MultiSigConfirmTx) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSigConfirmTx.Merge(m, src)
}
func (m *MultiSigConfirmTx) XXX_Size() int {
	return xxx_messageInfo_MultiSigConfirmTx.Size(m)
}
func (m *MultiSigConfirmTx) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSigConfirmTx.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSigConfirmTx proto.InternalMessageInfo

func (m *MultiSigConfirmTx) GetMultiSigAccAddr() string {
	if m != nil {
		return m.MultiSigAccAddr
	}
	return ""
}

func (m *MultiSigConfirmTx) GetTxId() uint64 {
	if m != nil {
		return m.TxId
	}
	return 0
}

func (m *MultiSigConfirmTx) GetConfirmOrRevoke() bool {
	if m != nil {
		return m.ConfirmOrRevoke
	}
	return false
}

//获取所有多重签名账号
type ReqMultiSigAccs struct {
	Start                int64    `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	End                  int64    `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReqMultiSigAccs) Reset()         { *m = ReqMultiSigAccs{} }
func (m *ReqMultiSigAccs) String() string { return proto.CompactTextString(m) }
func (*ReqMultiSigAccs) ProtoMessage()    {}
func (*ReqMultiSigAccs) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{13}
}

func (m *ReqMultiSigAccs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReqMultiSigAccs.Unmarshal(m, b)
}
func (m *ReqMultiSigAccs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReqMultiSigAccs.Marshal(b, m, deterministic)
}
func (m *ReqMultiSigAccs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReqMultiSigAccs.Merge(m, src)
}
func (m *ReqMultiSigAccs) XXX_Size() int {
	return xxx_messageInfo_ReqMultiSigAccs.Size(m)
}
func (m *ReqMultiSigAccs) XXX_DiscardUnknown() {
	xxx_messageInfo_ReqMultiSigAccs.DiscardUnknown(m)
}

var xxx_messageInfo_ReqMultiSigAccs proto.InternalMessageInfo

func (m *ReqMultiSigAccs) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *ReqMultiSigAccs) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

type ReplyMultiSigAccs struct {
	Address              []string `protobuf:"bytes,1,rep,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplyMultiSigAccs) Reset()         { *m = ReplyMultiSigAccs{} }
func (m *ReplyMultiSigAccs) String() string { return proto.CompactTextString(m) }
func (*ReplyMultiSigAccs) ProtoMessage()    {}
func (*ReplyMultiSigAccs) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{14}
}

func (m *ReplyMultiSigAccs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReplyMultiSigAccs.Unmarshal(m, b)
}
func (m *ReplyMultiSigAccs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReplyMultiSigAccs.Marshal(b, m, deterministic)
}
func (m *ReplyMultiSigAccs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplyMultiSigAccs.Merge(m, src)
}
func (m *ReplyMultiSigAccs) XXX_Size() int {
	return xxx_messageInfo_ReplyMultiSigAccs.Size(m)
}
func (m *ReplyMultiSigAccs) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplyMultiSigAccs.DiscardUnknown(m)
}

var xxx_messageInfo_ReplyMultiSigAccs proto.InternalMessageInfo

func (m *ReplyMultiSigAccs) GetAddress() []string {
	if m != nil {
		return m.Address
	}
	return nil
}

//获取指定多重签名账号的状态信息
type ReqMultiSigAccInfo struct {
	MultiSigAccAddr      string   `protobuf:"bytes,1,opt,name=multiSigAccAddr,proto3" json:"multiSigAccAddr,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReqMultiSigAccInfo) Reset()         { *m = ReqMultiSigAccInfo{} }
func (m *ReqMultiSigAccInfo) String() string { return proto.CompactTextString(m) }
func (*ReqMultiSigAccInfo) ProtoMessage()    {}
func (*ReqMultiSigAccInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{15}
}

func (m *ReqMultiSigAccInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReqMultiSigAccInfo.Unmarshal(m, b)
}
func (m *ReqMultiSigAccInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReqMultiSigAccInfo.Marshal(b, m, deterministic)
}
func (m *ReqMultiSigAccInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReqMultiSigAccInfo.Merge(m, src)
}
func (m *ReqMultiSigAccInfo) XXX_Size() int {
	return xxx_messageInfo_ReqMultiSigAccInfo.Size(m)
}
func (m *ReqMultiSigAccInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ReqMultiSigAccInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ReqMultiSigAccInfo proto.InternalMessageInfo

func (m *ReqMultiSigAccInfo) GetMultiSigAccAddr() string {
	if m != nil {
		return m.MultiSigAccAddr
	}
	return ""
}

//指定多重签名账号的状态信息
type ReplyMultiSigAccInfo struct {
	CreateAddr           string        `protobuf:"bytes,1,opt,name=createAddr,proto3" json:"createAddr,omitempty"`
	MultiSigAddr         string        `protobuf:"bytes,2,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	Owners               []*Owner      `protobuf:"bytes,3,rep,name=owners,proto3" json:"owners,omitempty"`
	DailyLimits          []*DailyLimit `protobuf:"bytes,4,rep,name=dailyLimits,proto3" json:"dailyLimits,omitempty"`
	TxCount              uint64        `protobuf:"varint,5,opt,name=txCount,proto3" json:"txCount,omitempty"`
	RequiredWeight       uint64        `protobuf:"varint,6,opt,name=requiredWeight,proto3" json:"requiredWeight,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ReplyMultiSigAccInfo) Reset()         { *m = ReplyMultiSigAccInfo{} }
func (m *ReplyMultiSigAccInfo) String() string { return proto.CompactTextString(m) }
func (*ReplyMultiSigAccInfo) ProtoMessage()    {}
func (*ReplyMultiSigAccInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{16}
}

func (m *ReplyMultiSigAccInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReplyMultiSigAccInfo.Unmarshal(m, b)
}
func (m *ReplyMultiSigAccInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReplyMultiSigAccInfo.Marshal(b, m, deterministic)
}
func (m *ReplyMultiSigAccInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplyMultiSigAccInfo.Merge(m, src)
}
func (m *ReplyMultiSigAccInfo) XXX_Size() int {
	return xxx_messageInfo_ReplyMultiSigAccInfo.Size(m)
}
func (m *ReplyMultiSigAccInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplyMultiSigAccInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ReplyMultiSigAccInfo proto.InternalMessageInfo

func (m *ReplyMultiSigAccInfo) GetCreateAddr() string {
	if m != nil {
		return m.CreateAddr
	}
	return ""
}

func (m *ReplyMultiSigAccInfo) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReplyMultiSigAccInfo) GetOwners() []*Owner {
	if m != nil {
		return m.Owners
	}
	return nil
}

func (m *ReplyMultiSigAccInfo) GetDailyLimits() []*DailyLimit {
	if m != nil {
		return m.DailyLimits
	}
	return nil
}

func (m *ReplyMultiSigAccInfo) GetTxCount() uint64 {
	if m != nil {
		return m.TxCount
	}
	return 0
}

func (m *ReplyMultiSigAccInfo) GetRequiredWeight() uint64 {
	if m != nil {
		return m.RequiredWeight
	}
	return 0
}

//获取txids设置过滤条件和区间，pending, executed
type ReqMultiSigTxids struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	FromTxId             uint64   `protobuf:"varint,2,opt,name=fromTxId,proto3" json:"fromTxId,omitempty"`
	ToTxId               uint64   `protobuf:"varint,3,opt,name=toTxId,proto3" json:"toTxId,omitempty"`
	Pending              bool     `protobuf:"varint,4,opt,name=pending,proto3" json:"pending,omitempty"`
	Executed             bool     `protobuf:"varint,5,opt,name=executed,proto3" json:"executed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReqMultiSigTxids) Reset()         { *m = ReqMultiSigTxids{} }
func (m *ReqMultiSigTxids) String() string { return proto.CompactTextString(m) }
func (*ReqMultiSigTxids) ProtoMessage()    {}
func (*ReqMultiSigTxids) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{17}
}

func (m *ReqMultiSigTxids) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReqMultiSigTxids.Unmarshal(m, b)
}
func (m *ReqMultiSigTxids) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReqMultiSigTxids.Marshal(b, m, deterministic)
}
func (m *ReqMultiSigTxids) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReqMultiSigTxids.Merge(m, src)
}
func (m *ReqMultiSigTxids) XXX_Size() int {
	return xxx_messageInfo_ReqMultiSigTxids.Size(m)
}
func (m *ReqMultiSigTxids) XXX_DiscardUnknown() {
	xxx_messageInfo_ReqMultiSigTxids.DiscardUnknown(m)
}

var xxx_messageInfo_ReqMultiSigTxids proto.InternalMessageInfo

func (m *ReqMultiSigTxids) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReqMultiSigTxids) GetFromTxId() uint64 {
	if m != nil {
		return m.FromTxId
	}
	return 0
}

func (m *ReqMultiSigTxids) GetToTxId() uint64 {
	if m != nil {
		return m.ToTxId
	}
	return 0
}

func (m *ReqMultiSigTxids) GetPending() bool {
	if m != nil {
		return m.Pending
	}
	return false
}

func (m *ReqMultiSigTxids) GetExecuted() bool {
	if m != nil {
		return m.Executed
	}
	return false
}

type ReplyMultiSigTxids struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	Txids                []uint64 `protobuf:"varint,2,rep,packed,name=txids,proto3" json:"txids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplyMultiSigTxids) Reset()         { *m = ReplyMultiSigTxids{} }
func (m *ReplyMultiSigTxids) String() string { return proto.CompactTextString(m) }
func (*ReplyMultiSigTxids) ProtoMessage()    {}
func (*ReplyMultiSigTxids) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{18}
}

func (m *ReplyMultiSigTxids) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReplyMultiSigTxids.Unmarshal(m, b)
}
func (m *ReplyMultiSigTxids) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReplyMultiSigTxids.Marshal(b, m, deterministic)
}
func (m *ReplyMultiSigTxids) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplyMultiSigTxids.Merge(m, src)
}
func (m *ReplyMultiSigTxids) XXX_Size() int {
	return xxx_messageInfo_ReplyMultiSigTxids.Size(m)
}
func (m *ReplyMultiSigTxids) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplyMultiSigTxids.DiscardUnknown(m)
}

var xxx_messageInfo_ReplyMultiSigTxids proto.InternalMessageInfo

func (m *ReplyMultiSigTxids) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReplyMultiSigTxids) GetTxids() []uint64 {
	if m != nil {
		return m.Txids
	}
	return nil
}

//获取txid交易的信息，以及参与确认的owner信息
type ReqMultiSigTxInfo struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	TxId                 uint64   `protobuf:"varint,2,opt,name=txId,proto3" json:"txId,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReqMultiSigTxInfo) Reset()         { *m = ReqMultiSigTxInfo{} }
func (m *ReqMultiSigTxInfo) String() string { return proto.CompactTextString(m) }
func (*ReqMultiSigTxInfo) ProtoMessage()    {}
func (*ReqMultiSigTxInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{19}
}

func (m *ReqMultiSigTxInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReqMultiSigTxInfo.Unmarshal(m, b)
}
func (m *ReqMultiSigTxInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReqMultiSigTxInfo.Marshal(b, m, deterministic)
}
func (m *ReqMultiSigTxInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReqMultiSigTxInfo.Merge(m, src)
}
func (m *ReqMultiSigTxInfo) XXX_Size() int {
	return xxx_messageInfo_ReqMultiSigTxInfo.Size(m)
}
func (m *ReqMultiSigTxInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ReqMultiSigTxInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ReqMultiSigTxInfo proto.InternalMessageInfo

func (m *ReqMultiSigTxInfo) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReqMultiSigTxInfo) GetTxId() uint64 {
	if m != nil {
		return m.TxId
	}
	return 0
}

type ReplyMultiSigTxInfo struct {
	MultiSigTxInfo       *MultiSigTx `protobuf:"bytes,1,opt,name=multiSigTxInfo,proto3" json:"multiSigTxInfo,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ReplyMultiSigTxInfo) Reset()         { *m = ReplyMultiSigTxInfo{} }
func (m *ReplyMultiSigTxInfo) String() string { return proto.CompactTextString(m) }
func (*ReplyMultiSigTxInfo) ProtoMessage()    {}
func (*ReplyMultiSigTxInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{20}
}

func (m *ReplyMultiSigTxInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReplyMultiSigTxInfo.Unmarshal(m, b)
}
func (m *ReplyMultiSigTxInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReplyMultiSigTxInfo.Marshal(b, m, deterministic)
}
func (m *ReplyMultiSigTxInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplyMultiSigTxInfo.Merge(m, src)
}
func (m *ReplyMultiSigTxInfo) XXX_Size() int {
	return xxx_messageInfo_ReplyMultiSigTxInfo.Size(m)
}
func (m *ReplyMultiSigTxInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplyMultiSigTxInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ReplyMultiSigTxInfo proto.InternalMessageInfo

func (m *ReplyMultiSigTxInfo) GetMultiSigTxInfo() *MultiSigTx {
	if m != nil {
		return m.MultiSigTxInfo
	}
	return nil
}

//获取指定资产当日剩余的免多重签名的余额
type ReqMultiSigAccUnSpentToday struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	Execer               string   `protobuf:"bytes,2,opt,name=execer,proto3" json:"execer,omitempty"`
	Symbol               string   `protobuf:"bytes,3,opt,name=symbol,proto3" json:"symbol,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReqMultiSigAccUnSpentToday) Reset()         { *m = ReqMultiSigAccUnSpentToday{} }
func (m *ReqMultiSigAccUnSpentToday) String() string { return proto.CompactTextString(m) }
func (*ReqMultiSigAccUnSpentToday) ProtoMessage()    {}
func (*ReqMultiSigAccUnSpentToday) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{21}
}

func (m *ReqMultiSigAccUnSpentToday) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReqMultiSigAccUnSpentToday.Unmarshal(m, b)
}
func (m *ReqMultiSigAccUnSpentToday) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReqMultiSigAccUnSpentToday.Marshal(b, m, deterministic)
}
func (m *ReqMultiSigAccUnSpentToday) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReqMultiSigAccUnSpentToday.Merge(m, src)
}
func (m *ReqMultiSigAccUnSpentToday) XXX_Size() int {
	return xxx_messageInfo_ReqMultiSigAccUnSpentToday.Size(m)
}
func (m *ReqMultiSigAccUnSpentToday) XXX_DiscardUnknown() {
	xxx_messageInfo_ReqMultiSigAccUnSpentToday.DiscardUnknown(m)
}

var xxx_messageInfo_ReqMultiSigAccUnSpentToday proto.InternalMessageInfo

func (m *ReqMultiSigAccUnSpentToday) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReqMultiSigAccUnSpentToday) GetExecer() string {
	if m != nil {
		return m.Execer
	}
	return ""
}

func (m *ReqMultiSigAccUnSpentToday) GetSymbol() string {
	if m != nil {
		return m.Symbol
	}
	return ""
}

type ReplyUnSpentAssets struct {
	UnSpentAssets        []*UnSpentAssets `protobuf:"bytes,3,rep,name=unSpentAssets,proto3" json:"unSpentAssets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ReplyUnSpentAssets) Reset()         { *m = ReplyUnSpentAssets{} }
func (m *ReplyUnSpentAssets) String() string { return proto.CompactTextString(m) }
func (*ReplyUnSpentAssets) ProtoMessage()    {}
func (*ReplyUnSpentAssets) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{22}
}

func (m *ReplyUnSpentAssets) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReplyUnSpentAssets.Unmarshal(m, b)
}
func (m *ReplyUnSpentAssets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReplyUnSpentAssets.Marshal(b, m, deterministic)
}
func (m *ReplyUnSpentAssets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplyUnSpentAssets.Merge(m, src)
}
func (m *ReplyUnSpentAssets) XXX_Size() int {
	return xxx_messageInfo_ReplyUnSpentAssets.Size(m)
}
func (m *ReplyUnSpentAssets) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplyUnSpentAssets.DiscardUnknown(m)
}

var xxx_messageInfo_ReplyUnSpentAssets proto.InternalMessageInfo

func (m *ReplyUnSpentAssets) GetUnSpentAssets() []*UnSpentAssets {
	if m != nil {
		return m.UnSpentAssets
	}
	return nil
}

type UnSpentAssets struct {
	Assets               *Assets  `protobuf:"bytes,1,opt,name=assets,proto3" json:"assets,omitempty"`
	Amount               uint64   `protobuf:"varint,2,opt,name=amount,proto3" json:"amount,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UnSpentAssets) Reset()         { *m = UnSpentAssets{} }
func (m *UnSpentAssets) String() string { return proto.CompactTextString(m) }
func (*UnSpentAssets) ProtoMessage()    {}
func (*UnSpentAssets) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{23}
}

func (m *UnSpentAssets) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UnSpentAssets.Unmarshal(m, b)
}
func (m *UnSpentAssets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UnSpentAssets.Marshal(b, m, deterministic)
}
func (m *UnSpentAssets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnSpentAssets.Merge(m, src)
}
func (m *UnSpentAssets) XXX_Size() int {
	return xxx_messageInfo_UnSpentAssets.Size(m)
}
func (m *UnSpentAssets) XXX_DiscardUnknown() {
	xxx_messageInfo_UnSpentAssets.DiscardUnknown(m)
}

var xxx_messageInfo_UnSpentAssets proto.InternalMessageInfo

func (m *UnSpentAssets) GetAssets() *Assets {
	if m != nil {
		return m.Assets
	}
	return nil
}

func (m *UnSpentAssets) GetAmount() uint64 {
	if m != nil {
		return m.Amount
	}
	return 0
}

// TyLogMultiSigAccCreate交易的执行Receipt
type ReceiptMultiSig struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiptMultiSig) Reset()         { *m = ReceiptMultiSig{} }
func (m *ReceiptMultiSig) String() string { return proto.CompactTextString(m) }
func (*ReceiptMultiSig) ProtoMessage()    {}
func (*ReceiptMultiSig) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{24}
}

func (m *ReceiptMultiSig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptMultiSig.Unmarshal(m, b)
}
func (m *ReceiptMultiSig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptMultiSig.Marshal(b, m, deterministic)
}
func (m *ReceiptMultiSig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptMultiSig.Merge(m, src)
}
func (m *ReceiptMultiSig) XXX_Size() int {
	return xxx_messageInfo_ReceiptMultiSig.Size(m)
}
func (m *ReceiptMultiSig) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptMultiSig.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptMultiSig proto.InternalMessageInfo

func (m *ReceiptMultiSig) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

type ReceiptOwnerAddOrDel struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	Owner                *Owner   `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	AddOrDel             bool     `protobuf:"varint,3,opt,name=addOrDel,proto3" json:"addOrDel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiptOwnerAddOrDel) Reset()         { *m = ReceiptOwnerAddOrDel{} }
func (m *ReceiptOwnerAddOrDel) String() string { return proto.CompactTextString(m) }
func (*ReceiptOwnerAddOrDel) ProtoMessage()    {}
func (*ReceiptOwnerAddOrDel) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{25}
}

func (m *ReceiptOwnerAddOrDel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptOwnerAddOrDel.Unmarshal(m, b)
}
func (m *ReceiptOwnerAddOrDel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptOwnerAddOrDel.Marshal(b, m, deterministic)
}
func (m *ReceiptOwnerAddOrDel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptOwnerAddOrDel.Merge(m, src)
}
func (m *ReceiptOwnerAddOrDel) XXX_Size() int {
	return xxx_messageInfo_ReceiptOwnerAddOrDel.Size(m)
}
func (m *ReceiptOwnerAddOrDel) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptOwnerAddOrDel.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptOwnerAddOrDel proto.InternalMessageInfo

func (m *ReceiptOwnerAddOrDel) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReceiptOwnerAddOrDel) GetOwner() *Owner {
	if m != nil {
		return m.Owner
	}
	return nil
}

func (m *ReceiptOwnerAddOrDel) GetAddOrDel() bool {
	if m != nil {
		return m.AddOrDel
	}
	return false
}

// TyLogMultiSigOwnerModify  = 10003 //输出modify的owner：preweight以及currentweight
// TyLogMultiSigOwnerReplace = 10004 //输出old的owner的信息：以及当前的owner信息：addr+weight
type ReceiptOwnerModOrRep struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	PrevOwner            *Owner   `protobuf:"bytes,2,opt,name=prevOwner,proto3" json:"prevOwner,omitempty"`
	CurrentOwner         *Owner   `protobuf:"bytes,3,opt,name=currentOwner,proto3" json:"currentOwner,omitempty"`
	ModOrRep             bool     `protobuf:"varint,4,opt,name=modOrRep,proto3" json:"modOrRep,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiptOwnerModOrRep) Reset()         { *m = ReceiptOwnerModOrRep{} }
func (m *ReceiptOwnerModOrRep) String() string { return proto.CompactTextString(m) }
func (*ReceiptOwnerModOrRep) ProtoMessage()    {}
func (*ReceiptOwnerModOrRep) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{26}
}

func (m *ReceiptOwnerModOrRep) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptOwnerModOrRep.Unmarshal(m, b)
}
func (m *ReceiptOwnerModOrRep) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptOwnerModOrRep.Marshal(b, m, deterministic)
}
func (m *ReceiptOwnerModOrRep) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptOwnerModOrRep.Merge(m, src)
}
func (m *ReceiptOwnerModOrRep) XXX_Size() int {
	return xxx_messageInfo_ReceiptOwnerModOrRep.Size(m)
}
func (m *ReceiptOwnerModOrRep) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptOwnerModOrRep.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptOwnerModOrRep proto.InternalMessageInfo

func (m *ReceiptOwnerModOrRep) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReceiptOwnerModOrRep) GetPrevOwner() *Owner {
	if m != nil {
		return m.PrevOwner
	}
	return nil
}

func (m *ReceiptOwnerModOrRep) GetCurrentOwner() *Owner {
	if m != nil {
		return m.CurrentOwner
	}
	return nil
}

func (m *ReceiptOwnerModOrRep) GetModOrRep() bool {
	if m != nil {
		return m.ModOrRep
	}
	return false
}

//多重签名账户的操作：ReqWeight，AssetDailyLimit
// TyLogMultiSigAccWeightModify     = 10005 //输出修改前后确认权重的值：preReqWeight和curReqWeight
type ReceiptWeightModify struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	PrevWeight           uint64   `protobuf:"varint,2,opt,name=prevWeight,proto3" json:"prevWeight,omitempty"`
	CurrentWeight        uint64   `protobuf:"varint,3,opt,name=currentWeight,proto3" json:"currentWeight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiptWeightModify) Reset()         { *m = ReceiptWeightModify{} }
func (m *ReceiptWeightModify) String() string { return proto.CompactTextString(m) }
func (*ReceiptWeightModify) ProtoMessage()    {}
func (*ReceiptWeightModify) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{27}
}

func (m *ReceiptWeightModify) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptWeightModify.Unmarshal(m, b)
}
func (m *ReceiptWeightModify) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptWeightModify.Marshal(b, m, deterministic)
}
func (m *ReceiptWeightModify) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptWeightModify.Merge(m, src)
}
func (m *ReceiptWeightModify) XXX_Size() int {
	return xxx_messageInfo_ReceiptWeightModify.Size(m)
}
func (m *ReceiptWeightModify) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptWeightModify.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptWeightModify proto.InternalMessageInfo

func (m *ReceiptWeightModify) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReceiptWeightModify) GetPrevWeight() uint64 {
	if m != nil {
		return m.PrevWeight
	}
	return 0
}

func (m *ReceiptWeightModify) GetCurrentWeight() uint64 {
	if m != nil {
		return m.CurrentWeight
	}
	return 0
}

// TyLogMultiSigAccDailyLimitAdd    = 10006 //输出add的DailyLimit：Symbol和DailyLimit
// TyLogMultiSigAccDailyLimitModify = 10007 //输出modify的DailyLimit：preDailyLimit以及currentDailyLimit
type ReceiptDailyLimitOperate struct {
	MultiSigAddr         string      `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	PrevDailyLimit       *DailyLimit `protobuf:"bytes,2,opt,name=prevDailyLimit,proto3" json:"prevDailyLimit,omitempty"`
	CurDailyLimit        *DailyLimit `protobuf:"bytes,3,opt,name=curDailyLimit,proto3" json:"curDailyLimit,omitempty"`
	AddOrModify          bool        `protobuf:"varint,4,opt,name=addOrModify,proto3" json:"addOrModify,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ReceiptDailyLimitOperate) Reset()         { *m = ReceiptDailyLimitOperate{} }
func (m *ReceiptDailyLimitOperate) String() string { return proto.CompactTextString(m) }
func (*ReceiptDailyLimitOperate) ProtoMessage()    {}
func (*ReceiptDailyLimitOperate) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{28}
}

func (m *ReceiptDailyLimitOperate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptDailyLimitOperate.Unmarshal(m, b)
}
func (m *ReceiptDailyLimitOperate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptDailyLimitOperate.Marshal(b, m, deterministic)
}
func (m *ReceiptDailyLimitOperate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptDailyLimitOperate.Merge(m, src)
}
func (m *ReceiptDailyLimitOperate) XXX_Size() int {
	return xxx_messageInfo_ReceiptDailyLimitOperate.Size(m)
}
func (m *ReceiptDailyLimitOperate) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptDailyLimitOperate.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptDailyLimitOperate proto.InternalMessageInfo

func (m *ReceiptDailyLimitOperate) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReceiptDailyLimitOperate) GetPrevDailyLimit() *DailyLimit {
	if m != nil {
		return m.PrevDailyLimit
	}
	return nil
}

func (m *ReceiptDailyLimitOperate) GetCurDailyLimit() *DailyLimit {
	if m != nil {
		return m.CurDailyLimit
	}
	return nil
}

func (m *ReceiptDailyLimitOperate) GetAddOrModify() bool {
	if m != nil {
		return m.AddOrModify
	}
	return false
}

//交易确认或者撤销（撤销值针对未执行的交易）
// TyLogMultiSigConfirmTx       = 10008 //输出确认的交易id，以及owner信息：addr+weight
// TyLogMultiSigConfirmTxRevoke = 10009 //输出撤销确认的交易id，以及owner信息：addr+weight
type ReceiptConfirmTx struct {
	MultiSigTxOwner      *MultiSigTxOwner `protobuf:"bytes,1,opt,name=multiSigTxOwner,proto3" json:"multiSigTxOwner,omitempty"`
	ConfirmeOrRevoke     bool             `protobuf:"varint,2,opt,name=confirmeOrRevoke,proto3" json:"confirmeOrRevoke,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ReceiptConfirmTx) Reset()         { *m = ReceiptConfirmTx{} }
func (m *ReceiptConfirmTx) String() string { return proto.CompactTextString(m) }
func (*ReceiptConfirmTx) ProtoMessage()    {}
func (*ReceiptConfirmTx) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{29}
}

func (m *ReceiptConfirmTx) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptConfirmTx.Unmarshal(m, b)
}
func (m *ReceiptConfirmTx) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptConfirmTx.Marshal(b, m, deterministic)
}
func (m *ReceiptConfirmTx) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptConfirmTx.Merge(m, src)
}
func (m *ReceiptConfirmTx) XXX_Size() int {
	return xxx_messageInfo_ReceiptConfirmTx.Size(m)
}
func (m *ReceiptConfirmTx) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptConfirmTx.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptConfirmTx proto.InternalMessageInfo

func (m *ReceiptConfirmTx) GetMultiSigTxOwner() *MultiSigTxOwner {
	if m != nil {
		return m.MultiSigTxOwner
	}
	return nil
}

func (m *ReceiptConfirmTx) GetConfirmeOrRevoke() bool {
	if m != nil {
		return m.ConfirmeOrRevoke
	}
	return false
}

//可能会修改dailyLimit的相关属性
type ReceiptAccDailyLimitUpdate struct {
	MultiSigAddr         string      `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	PrevDailyLimit       *DailyLimit `protobuf:"bytes,2,opt,name=prevDailyLimit,proto3" json:"prevDailyLimit,omitempty"`
	CurDailyLimit        *DailyLimit `protobuf:"bytes,3,opt,name=curDailyLimit,proto3" json:"curDailyLimit,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ReceiptAccDailyLimitUpdate) Reset()         { *m = ReceiptAccDailyLimitUpdate{} }
func (m *ReceiptAccDailyLimitUpdate) String() string { return proto.CompactTextString(m) }
func (*ReceiptAccDailyLimitUpdate) ProtoMessage()    {}
func (*ReceiptAccDailyLimitUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{30}
}

func (m *ReceiptAccDailyLimitUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptAccDailyLimitUpdate.Unmarshal(m, b)
}
func (m *ReceiptAccDailyLimitUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptAccDailyLimitUpdate.Marshal(b, m, deterministic)
}
func (m *ReceiptAccDailyLimitUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptAccDailyLimitUpdate.Merge(m, src)
}
func (m *ReceiptAccDailyLimitUpdate) XXX_Size() int {
	return xxx_messageInfo_ReceiptAccDailyLimitUpdate.Size(m)
}
func (m *ReceiptAccDailyLimitUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptAccDailyLimitUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptAccDailyLimitUpdate proto.InternalMessageInfo

func (m *ReceiptAccDailyLimitUpdate) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReceiptAccDailyLimitUpdate) GetPrevDailyLimit() *DailyLimit {
	if m != nil {
		return m.PrevDailyLimit
	}
	return nil
}

func (m *ReceiptAccDailyLimitUpdate) GetCurDailyLimit() *DailyLimit {
	if m != nil {
		return m.CurDailyLimit
	}
	return nil
}

//执行MultiSigAcc相关的交易可能会修改tx的执行状态和增加确认owner
type ReceiptMultiSigTx struct {
	MultiSigTxOwner      *MultiSigTxOwner `protobuf:"bytes,1,opt,name=multiSigTxOwner,proto3" json:"multiSigTxOwner,omitempty"`
	PrevExecuted         bool             `protobuf:"varint,2,opt,name=prevExecuted,proto3" json:"prevExecuted,omitempty"`
	CurExecuted          bool             `protobuf:"varint,3,opt,name=curExecuted,proto3" json:"curExecuted,omitempty"`
	SubmitOrConfirm      bool             `protobuf:"varint,4,opt,name=submitOrConfirm,proto3" json:"submitOrConfirm,omitempty"`
	TxHash               string           `protobuf:"bytes,5,opt,name=txHash,proto3" json:"txHash,omitempty"`
	TxType               uint64           `protobuf:"varint,6,opt,name=txType,proto3" json:"txType,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ReceiptMultiSigTx) Reset()         { *m = ReceiptMultiSigTx{} }
func (m *ReceiptMultiSigTx) String() string { return proto.CompactTextString(m) }
func (*ReceiptMultiSigTx) ProtoMessage()    {}
func (*ReceiptMultiSigTx) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{31}
}

func (m *ReceiptMultiSigTx) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptMultiSigTx.Unmarshal(m, b)
}
func (m *ReceiptMultiSigTx) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptMultiSigTx.Marshal(b, m, deterministic)
}
func (m *ReceiptMultiSigTx) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptMultiSigTx.Merge(m, src)
}
func (m *ReceiptMultiSigTx) XXX_Size() int {
	return xxx_messageInfo_ReceiptMultiSigTx.Size(m)
}
func (m *ReceiptMultiSigTx) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptMultiSigTx.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptMultiSigTx proto.InternalMessageInfo

func (m *ReceiptMultiSigTx) GetMultiSigTxOwner() *MultiSigTxOwner {
	if m != nil {
		return m.MultiSigTxOwner
	}
	return nil
}

func (m *ReceiptMultiSigTx) GetPrevExecuted() bool {
	if m != nil {
		return m.PrevExecuted
	}
	return false
}

func (m *ReceiptMultiSigTx) GetCurExecuted() bool {
	if m != nil {
		return m.CurExecuted
	}
	return false
}

func (m *ReceiptMultiSigTx) GetSubmitOrConfirm() bool {
	if m != nil {
		return m.SubmitOrConfirm
	}
	return false
}

func (m *ReceiptMultiSigTx) GetTxHash() string {
	if m != nil {
		return m.TxHash
	}
	return ""
}

func (m *ReceiptMultiSigTx) GetTxType() uint64 {
	if m != nil {
		return m.TxType
	}
	return 0
}

type ReceiptTxCountUpdate struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	CurTxCount           uint64   `protobuf:"varint,2,opt,name=curTxCount,proto3" json:"curTxCount,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiptTxCountUpdate) Reset()         { *m = ReceiptTxCountUpdate{} }
func (m *ReceiptTxCountUpdate) String() string { return proto.CompactTextString(m) }
func (*ReceiptTxCountUpdate) ProtoMessage()    {}
func (*ReceiptTxCountUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{32}
}

func (m *ReceiptTxCountUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiptTxCountUpdate.Unmarshal(m, b)
}
func (m *ReceiptTxCountUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiptTxCountUpdate.Marshal(b, m, deterministic)
}
func (m *ReceiptTxCountUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiptTxCountUpdate.Merge(m, src)
}
func (m *ReceiptTxCountUpdate) XXX_Size() int {
	return xxx_messageInfo_ReceiptTxCountUpdate.Size(m)
}
func (m *ReceiptTxCountUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiptTxCountUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiptTxCountUpdate proto.InternalMessageInfo

func (m *ReceiptTxCountUpdate) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReceiptTxCountUpdate) GetCurTxCount() uint64 {
	if m != nil {
		return m.CurTxCount
	}
	return 0
}

type MultiSigTxOwner struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	Txid                 uint64   `protobuf:"varint,2,opt,name=txid,proto3" json:"txid,omitempty"`
	ConfirmedOwner       *Owner   `protobuf:"bytes,3,opt,name=confirmedOwner,proto3" json:"confirmedOwner,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MultiSigTxOwner) Reset()         { *m = MultiSigTxOwner{} }
func (m *MultiSigTxOwner) String() string { return proto.CompactTextString(m) }
func (*MultiSigTxOwner) ProtoMessage()    {}
func (*MultiSigTxOwner) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{33}
}

func (m *MultiSigTxOwner) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MultiSigTxOwner.Unmarshal(m, b)
}
func (m *MultiSigTxOwner) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MultiSigTxOwner.Marshal(b, m, deterministic)
}
func (m *MultiSigTxOwner) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiSigTxOwner.Merge(m, src)
}
func (m *MultiSigTxOwner) XXX_Size() int {
	return xxx_messageInfo_MultiSigTxOwner.Size(m)
}
func (m *MultiSigTxOwner) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiSigTxOwner.DiscardUnknown(m)
}

var xxx_messageInfo_MultiSigTxOwner proto.InternalMessageInfo

func (m *MultiSigTxOwner) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *MultiSigTxOwner) GetTxid() uint64 {
	if m != nil {
		return m.Txid
	}
	return 0
}

func (m *MultiSigTxOwner) GetConfirmedOwner() *Owner {
	if m != nil {
		return m.ConfirmedOwner
	}
	return nil
}

type Uint64 struct {
	Data                 uint64   `protobuf:"varint,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Uint64) Reset()         { *m = Uint64{} }
func (m *Uint64) String() string { return proto.CompactTextString(m) }
func (*Uint64) ProtoMessage()    {}
func (*Uint64) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{34}
}

func (m *Uint64) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Uint64.Unmarshal(m, b)
}
func (m *Uint64) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Uint64.Marshal(b, m, deterministic)
}
func (m *Uint64) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Uint64.Merge(m, src)
}
func (m *Uint64) XXX_Size() int {
	return xxx_messageInfo_Uint64.Size(m)
}
func (m *Uint64) XXX_DiscardUnknown() {
	xxx_messageInfo_Uint64.DiscardUnknown(m)
}

var xxx_messageInfo_Uint64 proto.InternalMessageInfo

func (m *Uint64) GetData() uint64 {
	if m != nil {
		return m.Data
	}
	return 0
}

//记录账户收到固定资产的数量
type AccountAssets struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	Assets               *Assets  `protobuf:"bytes,2,opt,name=assets,proto3" json:"assets,omitempty"`
	Amount               int64    `protobuf:"varint,3,opt,name=amount,proto3" json:"amount,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccountAssets) Reset()         { *m = AccountAssets{} }
func (m *AccountAssets) String() string { return proto.CompactTextString(m) }
func (*AccountAssets) ProtoMessage()    {}
func (*AccountAssets) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{35}
}

func (m *AccountAssets) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccountAssets.Unmarshal(m, b)
}
func (m *AccountAssets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccountAssets.Marshal(b, m, deterministic)
}
func (m *AccountAssets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountAssets.Merge(m, src)
}
func (m *AccountAssets) XXX_Size() int {
	return xxx_messageInfo_AccountAssets.Size(m)
}
func (m *AccountAssets) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountAssets.DiscardUnknown(m)
}

var xxx_messageInfo_AccountAssets proto.InternalMessageInfo

func (m *AccountAssets) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *AccountAssets) GetAssets() *Assets {
	if m != nil {
		return m.Assets
	}
	return nil
}

func (m *AccountAssets) GetAmount() int64 {
	if m != nil {
		return m.Amount
	}
	return 0
}

//获取多重签名账户上的指定资产或者所有资产
type ReqAccAssets struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	Assets               *Assets  `protobuf:"bytes,2,opt,name=assets,proto3" json:"assets,omitempty"`
	IsAll                bool     `protobuf:"varint,3,opt,name=isAll,proto3" json:"isAll,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReqAccAssets) Reset()         { *m = ReqAccAssets{} }
func (m *ReqAccAssets) String() string { return proto.CompactTextString(m) }
func (*ReqAccAssets) ProtoMessage()    {}
func (*ReqAccAssets) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{36}
}

func (m *ReqAccAssets) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReqAccAssets.Unmarshal(m, b)
}
func (m *ReqAccAssets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReqAccAssets.Marshal(b, m, deterministic)
}
func (m *ReqAccAssets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReqAccAssets.Merge(m, src)
}
func (m *ReqAccAssets) XXX_Size() int {
	return xxx_messageInfo_ReqAccAssets.Size(m)
}
func (m *ReqAccAssets) XXX_DiscardUnknown() {
	xxx_messageInfo_ReqAccAssets.DiscardUnknown(m)
}

var xxx_messageInfo_ReqAccAssets proto.InternalMessageInfo

func (m *ReqAccAssets) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *ReqAccAssets) GetAssets() *Assets {
	if m != nil {
		return m.Assets
	}
	return nil
}

func (m *ReqAccAssets) GetIsAll() bool {
	if m != nil {
		return m.IsAll
	}
	return false
}

type ReplyAccAssets struct {
	AccAssets            []*AccAssets `protobuf:"bytes,1,rep,name=accAssets,proto3" json:"accAssets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ReplyAccAssets) Reset()         { *m = ReplyAccAssets{} }
func (m *ReplyAccAssets) String() string { return proto.CompactTextString(m) }
func (*ReplyAccAssets) ProtoMessage()    {}
func (*ReplyAccAssets) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{37}
}

func (m *ReplyAccAssets) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReplyAccAssets.Unmarshal(m, b)
}
func (m *ReplyAccAssets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReplyAccAssets.Marshal(b, m, deterministic)
}
func (m *ReplyAccAssets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplyAccAssets.Merge(m, src)
}
func (m *ReplyAccAssets) XXX_Size() int {
	return xxx_messageInfo_ReplyAccAssets.Size(m)
}
func (m *ReplyAccAssets) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplyAccAssets.DiscardUnknown(m)
}

var xxx_messageInfo_ReplyAccAssets proto.InternalMessageInfo

func (m *ReplyAccAssets) GetAccAssets() []*AccAssets {
	if m != nil {
		return m.AccAssets
	}
	return nil
}

//账户资产信息
type AccAssets struct {
	Assets               *Assets        `protobuf:"bytes,1,opt,name=assets,proto3" json:"assets,omitempty"`
	RecvAmount           int64          `protobuf:"varint,2,opt,name=recvAmount,proto3" json:"recvAmount,omitempty"`
	Account              *types.Account `protobuf:"bytes,3,opt,name=account,proto3" json:"account,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *AccAssets) Reset()         { *m = AccAssets{} }
func (m *AccAssets) String() string { return proto.CompactTextString(m) }
func (*AccAssets) ProtoMessage()    {}
func (*AccAssets) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{38}
}

func (m *AccAssets) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccAssets.Unmarshal(m, b)
}
func (m *AccAssets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccAssets.Marshal(b, m, deterministic)
}
func (m *AccAssets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccAssets.Merge(m, src)
}
func (m *AccAssets) XXX_Size() int {
	return xxx_messageInfo_AccAssets.Size(m)
}
func (m *AccAssets) XXX_DiscardUnknown() {
	xxx_messageInfo_AccAssets.DiscardUnknown(m)
}

var xxx_messageInfo_AccAssets proto.InternalMessageInfo

func (m *AccAssets) GetAssets() *Assets {
	if m != nil {
		return m.Assets
	}
	return nil
}

func (m *AccAssets) GetRecvAmount() int64 {
	if m != nil {
		return m.RecvAmount
	}
	return 0
}

func (m *AccAssets) GetAccount() *types.Account {
	if m != nil {
		return m.Account
	}
	return nil
}

type Assets struct {
	Execer               string   `protobuf:"bytes,1,opt,name=execer,proto3" json:"execer,omitempty"`
	Symbol               string   `protobuf:"bytes,2,opt,name=symbol,proto3" json:"symbol,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Assets) Reset()         { *m = Assets{} }
func (m *Assets) String() string { return proto.CompactTextString(m) }
func (*Assets) ProtoMessage()    {}
func (*Assets) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{39}
}

func (m *Assets) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Assets.Unmarshal(m, b)
}
func (m *Assets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Assets.Marshal(b, m, deterministic)
}
func (m *Assets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Assets.Merge(m, src)
}
func (m *Assets) XXX_Size() int {
	return xxx_messageInfo_Assets.Size(m)
}
func (m *Assets) XXX_DiscardUnknown() {
	xxx_messageInfo_Assets.DiscardUnknown(m)
}

var xxx_messageInfo_Assets proto.InternalMessageInfo

func (m *Assets) GetExecer() string {
	if m != nil {
		return m.Execer
	}
	return ""
}

func (m *Assets) GetSymbol() string {
	if m != nil {
		return m.Symbol
	}
	return ""
}

//账户地址列表
type AccAddress struct {
	Address              []string `protobuf:"bytes,1,rep,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccAddress) Reset()         { *m = AccAddress{} }
func (m *AccAddress) String() string { return proto.CompactTextString(m) }
func (*AccAddress) ProtoMessage()    {}
func (*AccAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{40}
}

func (m *AccAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccAddress.Unmarshal(m, b)
}
func (m *AccAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccAddress.Marshal(b, m, deterministic)
}
func (m *AccAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccAddress.Merge(m, src)
}
func (m *AccAddress) XXX_Size() int {
	return xxx_messageInfo_AccAddress.Size(m)
}
func (m *AccAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_AccAddress.DiscardUnknown(m)
}

var xxx_messageInfo_AccAddress proto.InternalMessageInfo

func (m *AccAddress) GetAddress() []string {
	if m != nil {
		return m.Address
	}
	return nil
}

// owner拥有的多重签名账户信息
type OwnerAttr struct {
	MultiSigAddr         string   `protobuf:"bytes,1,opt,name=multiSigAddr,proto3" json:"multiSigAddr,omitempty"`
	OwnerAddr            string   `protobuf:"bytes,2,opt,name=ownerAddr,proto3" json:"ownerAddr,omitempty"`
	Weight               uint64   `protobuf:"varint,3,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OwnerAttr) Reset()         { *m = OwnerAttr{} }
func (m *OwnerAttr) String() string { return proto.CompactTextString(m) }
func (*OwnerAttr) ProtoMessage()    {}
func (*OwnerAttr) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{41}
}

func (m *OwnerAttr) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OwnerAttr.Unmarshal(m, b)
}
func (m *OwnerAttr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OwnerAttr.Marshal(b, m, deterministic)
}
func (m *OwnerAttr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OwnerAttr.Merge(m, src)
}
func (m *OwnerAttr) XXX_Size() int {
	return xxx_messageInfo_OwnerAttr.Size(m)
}
func (m *OwnerAttr) XXX_DiscardUnknown() {
	xxx_messageInfo_OwnerAttr.DiscardUnknown(m)
}

var xxx_messageInfo_OwnerAttr proto.InternalMessageInfo

func (m *OwnerAttr) GetMultiSigAddr() string {
	if m != nil {
		return m.MultiSigAddr
	}
	return ""
}

func (m *OwnerAttr) GetOwnerAddr() string {
	if m != nil {
		return m.OwnerAddr
	}
	return ""
}

func (m *OwnerAttr) GetWeight() uint64 {
	if m != nil {
		return m.Weight
	}
	return 0
}

type OwnerAttrs struct {
	Items                []*OwnerAttr `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OwnerAttrs) Reset()         { *m = OwnerAttrs{} }
func (m *OwnerAttrs) String() string { return proto.CompactTextString(m) }
func (*OwnerAttrs) ProtoMessage()    {}
func (*OwnerAttrs) Descriptor() ([]byte, []int) {
	return fileDescriptor_62b8b91adf3febfa, []int{42}
}

func (m *OwnerAttrs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OwnerAttrs.Unmarshal(m, b)
}
func (m *OwnerAttrs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OwnerAttrs.Marshal(b, m, deterministic)
}
func (m *OwnerAttrs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OwnerAttrs.Merge(m, src)
}
func (m *OwnerAttrs) XXX_Size() int {
	return xxx_messageInfo_OwnerAttrs.Size(m)
}
func (m *OwnerAttrs) XXX_DiscardUnknown() {
	xxx_messageInfo_OwnerAttrs.DiscardUnknown(m)
}

var xxx_messageInfo_OwnerAttrs proto.InternalMessageInfo

func (m *OwnerAttrs) GetItems() []*OwnerAttr {
	if m != nil {
		return m.Items
	}
	return nil
}

func init() {
	proto.RegisterType((*MultiSig)(nil), "types.MultiSig")
	proto.RegisterType((*ConfirmedOwner)(nil), "types.ConfirmedOwner")
	proto.RegisterType((*MultiSigTx)(nil), "types.MultiSigTx")
	proto.RegisterType((*Owner)(nil), "types.Owner")
	proto.RegisterType((*DailyLimit)(nil), "types.DailyLimit")
	proto.RegisterType((*SymbolDailyLimit)(nil), "types.SymbolDailyLimit")
	proto.RegisterType((*MultiSigAction)(nil), "types.MultiSigAction")
	proto.RegisterType((*MultiSigAccCreate)(nil), "types.MultiSigAccCreate")
	proto.RegisterType((*MultiSigOwnerOperate)(nil), "types.MultiSigOwnerOperate")
	proto.RegisterType((*MultiSigAccOperate)(nil), "types.MultiSigAccOperate")
	proto.RegisterType((*MultiSigExecTransferFrom)(nil), "types.MultiSigExecTransferFrom")
	proto.RegisterType((*MultiSigExecTransferTo)(nil), "types.MultiSigExecTransferTo")
	proto.RegisterType((*MultiSigConfirmTx)(nil), "types.MultiSigConfirmTx")
	proto.RegisterType((*ReqMultiSigAccs)(nil), "types.ReqMultiSigAccs")
	proto.RegisterType((*ReplyMultiSigAccs)(nil), "types.ReplyMultiSigAccs")
	proto.RegisterType((*ReqMultiSigAccInfo)(nil), "types.ReqMultiSigAccInfo")
	proto.RegisterType((*ReplyMultiSigAccInfo)(nil), "types.ReplyMultiSigAccInfo")
	proto.RegisterType((*ReqMultiSigTxids)(nil), "types.ReqMultiSigTxids")
	proto.RegisterType((*ReplyMultiSigTxids)(nil), "types.ReplyMultiSigTxids")
	proto.RegisterType((*ReqMultiSigTxInfo)(nil), "types.ReqMultiSigTxInfo")
	proto.RegisterType((*ReplyMultiSigTxInfo)(nil), "types.ReplyMultiSigTxInfo")
	proto.RegisterType((*ReqMultiSigAccUnSpentToday)(nil), "types.ReqMultiSigAccUnSpentToday")
	proto.RegisterType((*ReplyUnSpentAssets)(nil), "types.ReplyUnSpentAssets")
	proto.RegisterType((*UnSpentAssets)(nil), "types.UnSpentAssets")
	proto.RegisterType((*ReceiptMultiSig)(nil), "types.ReceiptMultiSig")
	proto.RegisterType((*ReceiptOwnerAddOrDel)(nil), "types.ReceiptOwnerAddOrDel")
	proto.RegisterType((*ReceiptOwnerModOrRep)(nil), "types.ReceiptOwnerModOrRep")
	proto.RegisterType((*ReceiptWeightModify)(nil), "types.ReceiptWeightModify")
	proto.RegisterType((*ReceiptDailyLimitOperate)(nil), "types.ReceiptDailyLimitOperate")
	proto.RegisterType((*ReceiptConfirmTx)(nil), "types.ReceiptConfirmTx")
	proto.RegisterType((*ReceiptAccDailyLimitUpdate)(nil), "types.ReceiptAccDailyLimitUpdate")
	proto.RegisterType((*ReceiptMultiSigTx)(nil), "types.ReceiptMultiSigTx")
	proto.RegisterType((*ReceiptTxCountUpdate)(nil), "types.ReceiptTxCountUpdate")
	proto.RegisterType((*MultiSigTxOwner)(nil), "types.MultiSigTxOwner")
	proto.RegisterType((*Uint64)(nil), "types.Uint64")
	proto.RegisterType((*AccountAssets)(nil), "types.AccountAssets")
	proto.RegisterType((*ReqAccAssets)(nil), "types.ReqAccAssets")
	proto.RegisterType((*ReplyAccAssets)(nil), "types.ReplyAccAssets")
	proto.RegisterType((*AccAssets)(nil), "types.AccAssets")
	proto.RegisterType((*Assets)(nil), "types.Assets")
	proto.RegisterType((*AccAddress)(nil), "types.AccAddress")
	proto.RegisterType((*OwnerAttr)(nil), "types.OwnerAttr")
	proto.RegisterType((*OwnerAttrs)(nil), "types.OwnerAttrs")
}

func init() {
	proto.RegisterFile("multisig.proto", fileDescriptor_62b8b91adf3febfa)
}

var fileDescriptor_62b8b91adf3febfa = []byte{
	// 1572 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x18, 0xdd, 0x6e, 0xdc, 0x44,
	0x37, 0xf6, 0xfe, 0x24, 0x7b, 0x92, 0x6c, 0x93, 0xf9, 0xa2, 0x7c, 0x26, 0x94, 0x12, 0x8d, 0x4a,
	0xb5, 0xaa, 0x20, 0x42, 0x69, 0xa1, 0x14, 0x09, 0xd4, 0xa5, 0x69, 0x95, 0xaa, 0xa4, 0x29, 0xd3,
	0xad, 0x2a, 0x21, 0x71, 0xe1, 0xd8, 0x93, 0xd4, 0x62, 0xd7, 0xde, 0xda, 0xde, 0x64, 0x17, 0x90,
	0xca, 0x25, 0x2f, 0x00, 0x17, 0x5c, 0x20, 0x1e, 0x82, 0x0b, 0x9e, 0x00, 0x5e, 0x80, 0xb7, 0xe0,
	0x1a, 0x71, 0x8b, 0xe6, 0xcf, 0x9e, 0xb1, 0xbd, 0x91, 0x2b, 0x15, 0x84, 0xb8, 0xf3, 0x39, 0x73,
	0xe6, 0xfc, 0xff, 0x79, 0xa0, 0x3b, 0x9a, 0x0c, 0xd3, 0x20, 0x09, 0x4e, 0x76, 0xc6, 0x71, 0x94,
	0x46, 0xa8, 0x95, 0xce, 0xc6, 0x34, 0xd9, 0x5a, 0x75, 0x3d, 0x2f, 0x9a, 0x84, 0xa9, 0xc0, 0xe2,
	0xdf, 0x2d, 0x58, 0x3a, 0x60, 0x84, 0x8f, 0x82, 0x13, 0x74, 0x09, 0xc0, 0x8b, 0xa9, 0x9b, 0xd2,
	0xbe, 0xef, 0xc7, 0x8e, 0xb5, 0x6d, 0xf5, 0x3a, 0x44, 0xc3, 0x20, 0x0c, 0x2b, 0x23, 0x49, 0xcb,
	0x29, 0x6c, 0x4e, 0x61, 0xe0, 0xd0, 0x65, 0x68, 0x47, 0x67, 0x21, 0x8d, 0x13, 0xa7, 0xb1, 0xdd,
	0xe8, 0x2d, 0xef, 0xae, 0xec, 0x70, 0xb9, 0x3b, 0x87, 0x0c, 0x49, 0xe4, 0x19, 0xba, 0x06, 0xcb,
	0xbe, 0x1b, 0x0c, 0x67, 0x1f, 0x07, 0xa3, 0x20, 0x4d, 0x9c, 0x26, 0x27, 0x5d, 0x97, 0xa4, 0x7b,
	0xd9, 0x09, 0xd1, 0xa9, 0x90, 0x03, 0x8b, 0xe9, 0xf4, 0x36, 0x53, 0xde, 0x69, 0x6d, 0x5b, 0xbd,
	0x26, 0x51, 0x20, 0xba, 0x02, 0xdd, 0x98, 0x3e, 0x9b, 0x04, 0x31, 0xf5, 0x9f, 0xd0, 0xe0, 0xe4,
	0x69, 0xea, 0xb4, 0x39, 0x41, 0x01, 0x8b, 0xef, 0x42, 0xf7, 0x76, 0x14, 0x1e, 0x07, 0xf1, 0x88,
	0xfa, 0x5c, 0x21, 0x74, 0x1d, 0xba, 0x9e, 0x81, 0x71, 0xac, 0x0a, 0xb5, 0x0b, 0x34, 0xf8, 0x17,
	0x0b, 0x40, 0x79, 0x6d, 0x30, 0x45, 0x08, 0x9a, 0xe9, 0x34, 0xf0, 0xb9, 0xc7, 0x9a, 0x84, 0x7f,
	0xa3, 0x4d, 0x68, 0xa7, 0xd3, 0x7d, 0x37, 0x79, 0x2a, 0xbd, 0x24, 0x21, 0xb4, 0x05, 0x4b, 0x74,
	0x4a, 0xbd, 0x49, 0x4a, 0x7d, 0xa7, 0xb1, 0x6d, 0xf5, 0x96, 0x48, 0x06, 0x8b, 0x3b, 0x83, 0xd9,
	0x98, 0x3a, 0x4d, 0xce, 0x49, 0x42, 0x25, 0xbf, 0xb7, 0x2a, 0xfc, 0x5e, 0x36, 0xa4, 0x5d, 0xc3,
	0x90, 0x0f, 0xa0, 0x25, 0xfc, 0x70, 0x11, 0x3a, 0x3c, 0x34, 0x5a, 0xe4, 0x73, 0x04, 0x53, 0xec,
	0x4c, 0xf8, 0xd5, 0x16, 0x8a, 0x09, 0x08, 0x7f, 0x67, 0x01, 0xe4, 0xd1, 0x62, 0x64, 0xc9, 0x6c,
	0x74, 0x14, 0x0d, 0x25, 0x07, 0x09, 0x31, 0x3c, 0xb3, 0x91, 0xaa, 0x8c, 0x91, 0x10, 0xcb, 0xb7,
	0x3c, 0xbe, 0xdc, 0x1b, 0x4d, 0xa2, 0x61, 0xd8, 0x79, 0x32, 0xa6, 0x61, 0x3a, 0x88, 0x7c, 0x77,
	0x26, 0x7d, 0xa2, 0x61, 0x58, 0x42, 0x0c, 0xdd, 0x24, 0xdd, 0x73, 0x67, 0xdc, 0x25, 0x0d, 0xa2,
	0x40, 0x7c, 0x04, 0x6b, 0x8f, 0xb8, 0xec, 0xbf, 0x4f, 0x3b, 0xfc, 0x6d, 0x13, 0xba, 0x2a, 0x09,
	0xfa, 0x5e, 0x1a, 0x44, 0x21, 0xda, 0x87, 0xf5, 0x2c, 0x28, 0x9e, 0x77, 0x9b, 0x57, 0x0e, 0x97,
	0xb6, 0xbc, 0xeb, 0xc8, 0x38, 0x1c, 0x14, 0xcf, 0xf7, 0x17, 0x48, 0xf9, 0x12, 0xfa, 0x04, 0x36,
	0x14, 0x92, 0x07, 0xe8, 0x70, 0x4c, 0x63, 0xc6, 0xcc, 0xe6, 0xcc, 0x5e, 0x2d, 0x30, 0xd3, 0x49,
	0xf6, 0x17, 0x48, 0xe5, 0x55, 0x74, 0x1f, 0x90, 0x26, 0x47, 0x31, 0x6c, 0x70, 0x86, 0xaf, 0x94,
	0xb5, 0xcb, 0xd9, 0x55, 0x5c, 0xd3, 0x2d, 0x95, 0x15, 0x35, 0x98, 0xf2, 0x08, 0x95, 0x2d, 0xcd,
	0xce, 0x75, 0x4b, 0x33, 0x24, 0x7a, 0x02, 0x9b, 0x0a, 0x79, 0x67, 0x4a, 0xbd, 0x41, 0xec, 0x86,
	0xc9, 0x31, 0x8d, 0x07, 0x11, 0x8f, 0xe9, 0xf2, 0xee, 0x6b, 0x05, 0x76, 0x26, 0xd1, 0xfe, 0x02,
	0x99, 0x73, 0x1d, 0x7d, 0x06, 0x4e, 0xd5, 0xc9, 0xdd, 0x38, 0x1a, 0xf1, 0xf6, 0xb0, 0xbc, 0xfb,
	0xfa, 0x39, 0xac, 0x19, 0xd9, 0xfe, 0x02, 0x99, 0xcb, 0x02, 0x75, 0xc1, 0x1e, 0xcc, 0x9c, 0xc5,
	0x6d, 0xab, 0xd7, 0x22, 0xf6, 0x60, 0xf6, 0xd1, 0x22, 0xb4, 0x4e, 0xdd, 0xe1, 0x84, 0xe2, 0xef,
	0x2d, 0x58, 0x2f, 0x45, 0x59, 0xeb, 0x8b, 0xd6, 0x39, 0x7d, 0xb1, 0xdc, 0xc8, 0xec, 0xaa, 0x46,
	0x86, 0x6e, 0x94, 0x72, 0x73, 0x79, 0xf7, 0xff, 0x92, 0x63, 0x31, 0xf1, 0x8d, 0xa4, 0xfd, 0xd9,
	0x82, 0x8d, 0xaa, 0xac, 0x41, 0x3d, 0xb8, 0xa0, 0x85, 0x59, 0x6b, 0x03, 0x45, 0x34, 0xeb, 0x60,
	0xd1, 0x50, 0xf6, 0x18, 0x51, 0x31, 0x19, 0xcc, 0xce, 0x42, 0x7a, 0x26, 0xce, 0x1a, 0xe2, 0x4c,
	0xc1, 0xac, 0xc5, 0x84, 0xf4, 0x4c, 0x9a, 0x25, 0x8a, 0x39, 0x47, 0xa0, 0x6d, 0x58, 0x8e, 0x84,
	0x2a, 0x77, 0x87, 0xee, 0x89, 0x6c, 0xf0, 0x3a, 0x0a, 0xff, 0x6a, 0x01, 0x2a, 0xe7, 0xe7, 0x0b,
	0x28, 0x6e, 0x3a, 0xcd, 0xae, 0xed, 0x34, 0xf4, 0x26, 0xac, 0x87, 0xf4, 0x8c, 0x98, 0x81, 0x11,
	0x0d, 0xa1, 0x7c, 0x50, 0xb4, 0xa4, 0xc9, 0x9b, 0xbc, 0x61, 0xc9, 0x0f, 0x16, 0x38, 0xf3, 0x72,
	0xee, 0xbc, 0x36, 0xe5, 0x8e, 0xf8, 0xf0, 0xb3, 0x79, 0xaf, 0x93, 0x10, 0x1b, 0x3e, 0x61, 0x24,
	0x0b, 0xb9, 0x43, 0xf8, 0xb7, 0x1a, 0x32, 0xa1, 0x3b, 0x12, 0xa3, 0xa4, 0x43, 0x32, 0x98, 0xe5,
	0x6d, 0x1a, 0xc9, 0x11, 0x62, 0xa7, 0x11, 0xbb, 0x7f, 0xac, 0x4a, 0xa2, 0x43, 0xf8, 0x37, 0xfe,
	0xc6, 0x82, 0xcd, 0xea, 0x7a, 0xfb, 0xa7, 0xd5, 0xc3, 0x5f, 0xe6, 0xc5, 0x94, 0xf7, 0x8c, 0xfa,
	0x31, 0xe7, 0xa3, 0xf9, 0x9e, 0x2f, 0xcb, 0x88, 0x7f, 0xb3, 0xdb, 0x72, 0x0c, 0x1e, 0xc6, 0x84,
	0x9e, 0x46, 0x9f, 0x53, 0x39, 0x89, 0x8b, 0x68, 0x7c, 0x13, 0x2e, 0x10, 0xfa, 0x4c, 0x4b, 0xba,
	0x04, 0x6d, 0x40, 0x2b, 0x49, 0xdd, 0x38, 0xe5, 0x02, 0x1b, 0x44, 0x00, 0x68, 0x0d, 0x1a, 0x34,
	0xf4, 0xa5, 0xe9, 0xec, 0x13, 0xbf, 0x05, 0xeb, 0x84, 0x8e, 0x87, 0x33, 0xe3, 0xb2, 0x03, 0x8b,
	0xae, 0xef, 0xc7, 0x34, 0x11, 0x5d, 0xa0, 0x43, 0x14, 0x88, 0x3f, 0x04, 0x64, 0x4a, 0xba, 0x17,
	0x1e, 0x47, 0xf5, 0xed, 0xc4, 0x7f, 0x5a, 0xb0, 0x51, 0x94, 0xc7, 0x59, 0xfc, 0xe7, 0x77, 0xba,
	0x1f, 0x2d, 0x58, 0xd3, 0x5c, 0x37, 0x98, 0x06, 0x7e, 0x52, 0xb2, 0xca, 0xaa, 0xb0, 0x6a, 0x0b,
	0x96, 0x58, 0xb2, 0x0f, 0xf2, 0xf4, 0xc8, 0x60, 0xbe, 0x89, 0x45, 0xfc, 0xa4, 0x21, 0x37, 0x31,
	0x0e, 0x31, 0x75, 0xc7, 0x34, 0xf4, 0x83, 0x50, 0xd5, 0xb5, 0x02, 0x8d, 0xbd, 0xae, 0x65, 0xee,
	0x75, 0xf8, 0x01, 0x0b, 0xae, 0x16, 0x9b, 0xfa, 0x3a, 0x6e, 0x40, 0x8b, 0x6d, 0x93, 0x89, 0x63,
	0x6f, 0x37, 0x7a, 0x4d, 0x22, 0x00, 0x7c, 0x9f, 0xe5, 0x96, 0x66, 0x31, 0x0f, 0x74, 0x1d, 0x76,
	0x15, 0xd5, 0x80, 0x1f, 0xc2, 0xff, 0x0a, 0xca, 0x71, 0x76, 0x37, 0xe5, 0x0f, 0x44, 0x86, 0x91,
	0x7b, 0xcc, 0x7a, 0x61, 0x66, 0x0e, 0xa6, 0xa4, 0x40, 0x88, 0xc7, 0xb0, 0x65, 0xe6, 0xf2, 0xe3,
	0xf0, 0x51, 0xbe, 0xb4, 0xd5, 0xd1, 0x73, 0xde, 0x4a, 0x96, 0x37, 0x9f, 0x86, 0xde, 0x7c, 0xf0,
	0x43, 0xe9, 0x60, 0x29, 0xa8, 0x9f, 0x24, 0x34, 0x4d, 0xd0, 0xfb, 0xb0, 0x3a, 0xd1, 0x11, 0x32,
	0x7b, 0x37, 0xa4, 0x05, 0x06, 0x31, 0x31, 0x49, 0xf1, 0x03, 0x58, 0x35, 0x99, 0xbd, 0x01, 0x6d,
	0x57, 0x70, 0x11, 0x7e, 0x58, 0x95, 0x5c, 0xe4, 0x75, 0x79, 0x58, 0x68, 0x83, 0x4d, 0xd5, 0x06,
	0xf1, 0x3b, 0xac, 0x93, 0x78, 0x34, 0x18, 0xa7, 0xd9, 0xdf, 0x56, 0x0d, 0x47, 0xe0, 0x2f, 0x58,
	0x55, 0xf3, 0x6b, 0x87, 0x72, 0x19, 0x3f, 0x8c, 0xf7, 0xe8, 0xb0, 0x96, 0x13, 0x31, 0xb4, 0xa2,
	0x6c, 0x48, 0x17, 0x8b, 0x56, 0x1c, 0xb1, 0xac, 0x75, 0x25, 0x4f, 0xf5, 0x37, 0xa2, 0x60, 0xfc,
	0x93, 0x65, 0x0a, 0x3f, 0x88, 0x7c, 0xd6, 0x18, 0xc7, 0xb5, 0x84, 0x5f, 0x85, 0xce, 0x38, 0xa6,
	0xa7, 0x87, 0x73, 0x15, 0xc8, 0x8f, 0xd1, 0xdb, 0xb0, 0xe2, 0x4d, 0xe2, 0x98, 0x86, 0x69, 0xbe,
	0x38, 0x14, 0xc9, 0x0d, 0x0a, 0xa6, 0xf6, 0x48, 0x6a, 0x23, 0xeb, 0x30, 0x83, 0xf1, 0x73, 0x96,
	0xcf, 0x5c, 0x6b, 0xd1, 0x20, 0x0e, 0x22, 0x3f, 0x38, 0xae, 0x97, 0x76, 0x97, 0x00, 0x98, 0x56,
	0xc6, 0xe6, 0xa5, 0x61, 0xd0, 0x65, 0x58, 0x95, 0x6a, 0x18, 0x3b, 0x80, 0x89, 0xc4, 0xbf, 0x59,
	0xe0, 0x48, 0x0d, 0xf2, 0xae, 0xa7, 0xb6, 0x95, 0x3a, 0x6a, 0xdc, 0x84, 0x2e, 0x13, 0xba, 0x57,
	0xdc, 0x55, 0x2a, 0x7a, 0x69, 0x81, 0x10, 0xdd, 0xe0, 0x1a, 0xee, 0x15, 0x57, 0xc3, 0x8a, 0x9b,
	0x26, 0x1d, 0x5b, 0x5a, 0x78, 0xe0, 0x85, 0xb7, 0xd4, 0xd2, 0xa2, 0xa1, 0xf0, 0xd7, 0xbc, 0xcf,
	0x72, 0xb3, 0xf2, 0x41, 0x7c, 0x2b, 0x1f, 0x50, 0x83, 0xa9, 0xfa, 0x7f, 0x66, 0x12, 0x37, 0x4b,
	0x6d, 0x42, 0xc4, 0xb1, 0x48, 0x8e, 0xae, 0xc2, 0x9a, 0xfa, 0x27, 0xcd, 0xa6, 0xb1, 0xcd, 0xa5,
	0x97, 0xf0, 0x2c, 0x23, 0xb7, 0xa4, 0x0a, 0x7d, 0xcf, 0xcb, 0xb5, 0x7f, 0x3c, 0xf6, 0xff, 0xc5,
	0xbe, 0xc5, 0x7f, 0x58, 0xac, 0x5f, 0x1b, 0xc5, 0xff, 0x52, 0x5c, 0x87, 0x61, 0x85, 0xa9, 0x78,
	0x47, 0x8d, 0x1d, 0xe1, 0x36, 0x03, 0xc7, 0xe2, 0xea, 0x4d, 0xe2, 0x3b, 0xe6, 0x8b, 0x83, 0x8e,
	0x62, 0x3b, 0x46, 0x32, 0x39, 0x62, 0x29, 0x1a, 0xcb, 0xb8, 0xca, 0xe8, 0x17, 0xd1, 0xda, 0x93,
	0x46, 0xcb, 0x78, 0xd2, 0xc8, 0x9f, 0x2d, 0xda, 0xfa, 0xb3, 0x05, 0xfe, 0x34, 0xeb, 0x1f, 0x03,
	0x31, 0xd3, 0x5f, 0x20, 0x4e, 0x6c, 0x6d, 0x99, 0xc4, 0xf2, 0x9e, 0x2a, 0xc5, 0x1c, 0x83, 0x9f,
	0xc3, 0x85, 0x83, 0xb2, 0x3b, 0xea, 0x0d, 0xc0, 0x40, 0x1b, 0x80, 0x81, 0x5f, 0xf1, 0x72, 0x52,
	0xd5, 0x80, 0x8a, 0x2f, 0x27, 0x17, 0xa1, 0xfd, 0x38, 0x08, 0xd3, 0x77, 0xaf, 0x33, 0x9e, 0xbe,
	0x9b, 0xba, 0xea, 0xf5, 0x87, 0x7d, 0xe3, 0x18, 0x56, 0xfb, 0xe2, 0x9d, 0x4d, 0x8e, 0x8f, 0x3a,
	0xca, 0xe5, 0x23, 0xc6, 0xae, 0x37, 0x62, 0x1a, 0xfa, 0xa6, 0x8d, 0x23, 0x58, 0x21, 0xf4, 0x19,
	0x5b, 0x08, 0x5f, 0xba, 0xc8, 0x0d, 0x68, 0x05, 0x49, 0x7f, 0xa8, 0x66, 0x84, 0x00, 0xf0, 0x2d,
	0xe8, 0xf2, 0xa9, 0x9b, 0x8b, 0xdc, 0x81, 0x8e, 0xab, 0x00, 0xf9, 0x9f, 0xbb, 0xa6, 0x38, 0x2a,
	0x3c, 0xc9, 0x49, 0xf0, 0x57, 0xd0, 0xc9, 0x2f, 0xd7, 0x9c, 0xb0, 0x97, 0x00, 0x62, 0xea, 0x9d,
	0xf6, 0xf5, 0x9f, 0x0d, 0x0d, 0x83, 0x7a, 0xb0, 0x28, 0x9f, 0x38, 0x65, 0x1c, 0xbb, 0xb9, 0x06,
	0x0c, 0x4b, 0xd4, 0x31, 0x7e, 0x0f, 0xda, 0xfd, 0xcc, 0xa5, 0x72, 0xdf, 0xb0, 0xe6, 0xec, 0x1b,
	0xb6, 0xb1, 0x6f, 0x5c, 0x01, 0x90, 0x8b, 0x37, 0x4d, 0xce, 0xdb, 0xea, 0x29, 0x74, 0xc4, 0xdc,
	0x4e, 0xd3, 0x7a, 0xf9, 0x69, 0x3c, 0xc3, 0xd9, 0xf3, 0x9f, 0xe1, 0x1a, 0xc6, 0x33, 0xdc, 0x75,
	0x80, 0x4c, 0x4c, 0x82, 0xae, 0x40, 0x2b, 0x48, 0xe9, 0xa8, 0x18, 0x80, 0x8c, 0x82, 0x88, 0xe3,
	0xa3, 0x36, 0x7f, 0x01, 0xbe, 0xf6, 0x57, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x1b, 0x43, 0x0b,
	0x29, 0x16, 0x00, 0x00,
}
